/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventFunctionCallArgumentsDelta
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA;
    private final String itemId;
    private final int outputIndex;
    private final String delta;

    private ResponsesStreamEventFunctionCallArgumentsDelta(String itemId, int outputIndex, String delta) {
        this.itemId = itemId;
        this.outputIndex = outputIndex;
        this.delta = delta;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public String getItemId() {
        return this.itemId;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public String getDelta() {
        return this.delta;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("item_id", this.itemId);
        jsonWriter.writeIntField("output_index", this.outputIndex);
        jsonWriter.writeStringField("delta", this.delta);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventFunctionCallArgumentsDelta fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventFunctionCallArgumentsDelta)jsonReader.readObject(reader -> {
            String itemId = null;
            int outputIndex = 0;
            String delta = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("item_id".equals(fieldName)) {
                    itemId = reader.getString();
                    continue;
                }
                if ("output_index".equals(fieldName)) {
                    outputIndex = reader.getInt();
                    continue;
                }
                if ("delta".equals(fieldName)) {
                    delta = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventFunctionCallArgumentsDelta deserializedResponsesStreamEventFunctionCallArgumentsDelta = new ResponsesStreamEventFunctionCallArgumentsDelta(itemId, outputIndex, delta);
            deserializedResponsesStreamEventFunctionCallArgumentsDelta.type = type;
            return deserializedResponsesStreamEventFunctionCallArgumentsDelta;
        });
    }
}

