/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesOutputTextAnnotation;
import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventOutputTextAnnotationAdded
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_OUTPUT_TEXT_ANNOTATION_ADDED;
    private final String itemId;
    private final int outputIndex;
    private final int contentIndex;
    private final ResponsesOutputTextAnnotation annotation;

    private ResponsesStreamEventOutputTextAnnotationAdded(String itemId, int outputIndex, int contentIndex, ResponsesOutputTextAnnotation annotation) {
        this.itemId = itemId;
        this.outputIndex = outputIndex;
        this.contentIndex = contentIndex;
        this.annotation = annotation;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public String getItemId() {
        return this.itemId;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public int getContentIndex() {
        return this.contentIndex;
    }

    public ResponsesOutputTextAnnotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("item_id", this.itemId);
        jsonWriter.writeIntField("output_index", this.outputIndex);
        jsonWriter.writeIntField("content_index", this.contentIndex);
        jsonWriter.writeJsonField("annotation", (JsonSerializable)this.annotation);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventOutputTextAnnotationAdded fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventOutputTextAnnotationAdded)jsonReader.readObject(reader -> {
            String itemId = null;
            int outputIndex = 0;
            int contentIndex = 0;
            ResponsesOutputTextAnnotation annotation = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_OUTPUT_TEXT_ANNOTATION_ADDED;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("item_id".equals(fieldName)) {
                    itemId = reader.getString();
                    continue;
                }
                if ("output_index".equals(fieldName)) {
                    outputIndex = reader.getInt();
                    continue;
                }
                if ("content_index".equals(fieldName)) {
                    contentIndex = reader.getInt();
                    continue;
                }
                if ("annotation".equals(fieldName)) {
                    annotation = ResponsesOutputTextAnnotation.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventOutputTextAnnotationAdded deserializedResponsesStreamEventOutputTextAnnotationAdded = new ResponsesStreamEventOutputTextAnnotationAdded(itemId, outputIndex, contentIndex, annotation);
            deserializedResponsesStreamEventOutputTextAnnotationAdded.type = type;
            return deserializedResponsesStreamEventOutputTextAnnotationAdded;
        });
    }
}

