/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesComputerTool;
import com.azure.ai.openai.responses.models.ResponsesFileSearchTool;
import com.azure.ai.openai.responses.models.ResponsesFunctionTool;
import com.azure.ai.openai.responses.models.ResponsesToolType;
import com.azure.ai.openai.responses.models.ResponsesWebSearchTool;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class ResponsesTool
implements JsonSerializable<ResponsesTool> {
    private ResponsesToolType type;

    public ResponsesToolType getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesTool fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesTool)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ResponsesTool responsesTool;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("function".equals(discriminatorValue)) {
                    responsesTool = ResponsesFunctionTool.fromJson(readerToUse.reset());
                    return responsesTool;
                }
                if ("file_search".equals(discriminatorValue)) {
                    responsesTool = ResponsesFileSearchTool.fromJson(readerToUse.reset());
                    return responsesTool;
                }
                if ("web_search_preview".equals(discriminatorValue)) {
                    responsesTool = ResponsesWebSearchTool.fromJson(readerToUse.reset());
                    return responsesTool;
                }
                if ("computer_use_preview".equals(discriminatorValue)) {
                    responsesTool = ResponsesComputerTool.fromJson(readerToUse.reset());
                    return responsesTool;
                }
                responsesTool = ResponsesTool.fromJsonKnownDiscriminator(readerToUse.reset());
                return responsesTool;
            }
        });
    }

    static ResponsesTool fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ResponsesTool)jsonReader.readObject(reader -> {
            ResponsesTool deserializedResponsesTool = new ResponsesTool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResponsesTool.type = ResponsesToolType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResponsesTool;
        });
    }
}

