/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesToolChoiceObject;
import com.azure.ai.openai.responses.models.ResponsesToolChoiceObjectType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesToolChoiceObjectFunction
extends ResponsesToolChoiceObject {
    private ResponsesToolChoiceObjectType type = ResponsesToolChoiceObjectType.FUNCTION;
    private final String name;

    public ResponsesToolChoiceObjectFunction(String name) {
        this.name = name;
    }

    @Override
    public ResponsesToolChoiceObjectType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesToolChoiceObjectFunction fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesToolChoiceObjectFunction)jsonReader.readObject(reader -> {
            String name = null;
            ResponsesToolChoiceObjectType type = ResponsesToolChoiceObjectType.FUNCTION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesToolChoiceObjectType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesToolChoiceObjectFunction deserializedResponsesToolChoiceObjectFunction = new ResponsesToolChoiceObjectFunction(name);
            deserializedResponsesToolChoiceObjectFunction.type = type;
            return deserializedResponsesToolChoiceObjectFunction;
        });
    }
}

