// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** A description of the intended purpose of a message within a chat completions interaction. */
public final class ChatRole extends ExpandableStringEnum<ChatRole> {

    /** The role that instructs or sets the behavior of the assistant. */
    @Generated public static final ChatRole SYSTEM = fromString("system");

    /** The role that provides responses to system-instructed, user-prompted input. */
    @Generated public static final ChatRole ASSISTANT = fromString("assistant");

    /** The role that provides input for chat completions. */
    @Generated public static final ChatRole USER = fromString("user");

    /**
     * Creates a new instance of ChatRole value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ChatRole() {}

    /**
     * Creates or finds a ChatRole from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ChatRole.
     */
    @Generated
    @JsonCreator
    public static ChatRole fromString(String name) {
        return fromString(name, ChatRole.class);
    }

    /**
     * Gets known ChatRole values.
     *
     * @return known ChatRole values.
     */
    @Generated
    public static Collection<ChatRole> values() {
        return values(ChatRole.class);
    }

    /** The role that provides function results for char completions. */
    @Generated public static final ChatRole FUNCTION = fromString("function");
}
