// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.models.ResponseError;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A polling status update or final response payload for an image operation. */
@Immutable
public final class ImageOperationResponse {

    /*
     * The ID of the operation.
     */
    @Generated
    @JsonProperty(value = "id")
    private String id;

    /*
     * A timestamp when this job or item was created (in unix epochs).
     */
    @Generated
    @JsonProperty(value = "created")
    private long created;

    /*
     * A timestamp when this operation and its associated images expire and will be deleted (in unix epochs).
     */
    @Generated
    @JsonProperty(value = "expires")
    private Long expires;

    /*
     * The result of the operation if the operation succeeded.
     */
    @Generated
    @JsonProperty(value = "result")
    private ImageResponse result;

    /*
     * The status of the operation
     */
    @Generated
    @JsonProperty(value = "status")
    private AzureOpenAIOperationState status;

    /*
     * The error if the operation failed.
     */
    @Generated
    @JsonProperty(value = "error")
    private ResponseError error;

    /**
     * Get the id property: The ID of the operation.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the created property: A timestamp when this job or item was created (in unix epochs).
     *
     * @return the created value.
     */
    @Generated
    public long getCreated() {
        return this.created;
    }

    /**
     * Get the expires property: A timestamp when this operation and its associated images expire and will be deleted
     * (in unix epochs).
     *
     * @return the expires value.
     */
    @Generated
    public Long getExpires() {
        return this.expires;
    }

    /**
     * Get the result property: The result of the operation if the operation succeeded.
     *
     * @return the result value.
     */
    @Generated
    public ImageResponse getResult() {
        return this.result;
    }

    /**
     * Get the status property: The status of the operation.
     *
     * @return the status value.
     */
    @Generated
    public AzureOpenAIOperationState getStatus() {
        return this.status;
    }

    /**
     * Get the error property: The error if the operation failed.
     *
     * @return the error value.
     */
    @Generated
    public ResponseError getError() {
        return this.error;
    }

    /**
     * Creates an instance of ImageOperationResponse class.
     *
     * @param id the id value to set.
     * @param created the created value to set.
     * @param status the status value to set.
     */
    @Generated
    @JsonCreator
    private ImageOperationResponse(
            @JsonProperty(value = "id") String id,
            @JsonProperty(value = "created") long created,
            @JsonProperty(value = "status") AzureOpenAIOperationState status) {
        this.id = id;
        this.created = created;
        this.status = status;
    }
}
