// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Provides status details for long running operations. */
@Immutable
public final class ImageOperationStatus {

    /*
     * The unique ID of the operation.
     */
    @Generated
    @JsonProperty(value = "id")
    private String id;

    /*
     * The status of the operation
     */
    @Generated
    @JsonProperty(value = "status")
    private State status;

    /**
     * Creates an instance of ImageOperationStatus class.
     *
     * @param id the id value to set.
     * @param status the status value to set.
     */
    @Generated
    @JsonCreator
    private ImageOperationStatus(@JsonProperty(value = "id") String id, @JsonProperty(value = "status") State status) {
        this.id = id;
        this.status = status;
    }

    /**
     * Get the id property: The unique ID of the operation.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the status property: The status of the operation.
     *
     * @return the status value.
     */
    @Generated
    public State getStatus() {
        return this.status;
    }
}
