// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The state of a job or item. */
public final class State extends ExpandableStringEnum<State> {

    /** The operation was created and is queued to be processed in the future. */
    @Generated public static final State NOT_RUNNING = fromString("notRunning");

    /** The operation has started to be processed. */
    @Generated public static final State RUNNING = fromString("running");

    /** The operation has successfully be processed and is ready for consumption. */
    @Generated public static final State SUCCEEDED = fromString("succeeded");

    /** The operation has been canceled and is incomplete. */
    @Generated public static final State CANCELED = fromString("canceled");

    /** The operation has completed processing with a failure and cannot be further consumed. */
    @Generated public static final State FAILED = fromString("failed");

    /** The entity has been deleted but may still be referenced by other entities predating the deletion. */
    @Generated public static final State DELETED = fromString("deleted");

    /**
     * Creates a new instance of State value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public State() {}

    /**
     * Creates or finds a State from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding State.
     */
    @Generated
    @JsonCreator
    public static State fromString(String name) {
        return fromString(name, State.class);
    }

    /**
     * Gets known State values.
     *
     * @return known State values.
     */
    @Generated
    public static Collection<State> values() {
        return values(State.class);
    }
}
