/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai;

import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.implementation.CompletionsUtils;
import com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.ai.openai.models.ImageGenerationOptions;
import com.azure.ai.openai.models.ImageOperationResponse;
import com.azure.ai.openai.models.ImageResponse;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

@ServiceClient(builder=OpenAIClientBuilder.class)
public final class OpenAIClient {
    private static final ClientLogger LOGGER = new ClientLogger(OpenAIClient.class);
    private final OpenAIClientImpl serviceClient;
    private final NonAzureOpenAIClientImpl openAIServiceClient;

    OpenAIClient(OpenAIClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.openAIServiceClient = null;
    }

    OpenAIClient(NonAzureOpenAIClientImpl serviceClient) {
        this.serviceClient = null;
        this.openAIServiceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(String deploymentOrModelName, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptions, requestOptions) : this.serviceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(String deploymentOrModelName, BinaryData completionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions) : this.serviceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions, requestOptions) : this.serviceClient.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Embeddings getEmbeddings(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (Embeddings)((BinaryData)this.getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)embeddingsOptions), requestOptions).getValue()).toObject(Embeddings.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (Completions)((BinaryData)this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).getValue()).toObject(Completions.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, String prompt) {
        return this.getCompletions(deploymentOrModelName, CompletionsUtils.defaultCompletionsOptions(prompt));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<Completions> getCompletionsStream(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        completionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = ((BinaryData)this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<Completions> completionsStream = new OpenAIServerSentEvents<Completions>((Flux<ByteBuffer>)responseStream, Completions.class);
        return new IterableStream(completionsStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ChatCompletions getChatCompletions(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (ChatCompletions)((BinaryData)this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).getValue()).toObject(ChatCompletions.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<ChatCompletions> getChatCompletionsStream(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        chatCompletionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = ((BinaryData)this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream = new OpenAIServerSentEvents<ChatCompletions>((Flux<ByteBuffer>)responseStream, ChatCompletions.class);
        return new IterableStream(chatCompletionsStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ImageResponse getImages(ImageGenerationOptions imageGenerationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        BinaryData imageGenerationOptionsBinaryData = BinaryData.fromObject((Object)imageGenerationOptions);
        if (this.openAIServiceClient != null) {
            return (ImageResponse)((BinaryData)this.openAIServiceClient.generateImageWithResponse(imageGenerationOptionsBinaryData, requestOptions).getValue()).toObject(ImageResponse.class);
        }
        try {
            return (ImageResponse)this.serviceClient.beginBeginAzureBatchImageGenerationAsync(imageGenerationOptionsBinaryData, requestOptions).last().flatMap(it -> it.getFinalResult()).map(it -> ((ImageOperationResponse)it.toObject(ImageOperationResponse.class)).getResult()).block();
        }
        catch (Exception e) {
            Throwable unwrapped = Exceptions.unwrap((Throwable)e);
            if (unwrapped instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)unwrapped);
            }
            if (unwrapped instanceof IOException) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException((IOException)unwrapped));
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(unwrapped));
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<BinaryData, BinaryData> beginBeginAzureBatchImageGeneration(BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        return this.serviceClient.beginBeginAzureBatchImageGeneration(imageGenerationOptions, requestOptions);
    }
}

