// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * A representation of configuration data for a single Azure OpenAI chat extension. This will be used by a chat
 * completions request that should use Azure OpenAI chat extensions to augment the response behavior. The use of this
 * configuration is compatible only with Azure OpenAI.
 */
public final class AzureChatExtensionType extends ExpandableStringEnum<AzureChatExtensionType> {

    /** Represents the use of Azure Cognitive Search as an Azure OpenAI chat extension. */
    @Generated public static final AzureChatExtensionType AZURE_COGNITIVE_SEARCH = fromString("AzureCognitiveSearch");

    /**
     * Creates a new instance of AzureChatExtensionType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public AzureChatExtensionType() {}

    /**
     * Creates or finds a AzureChatExtensionType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AzureChatExtensionType.
     */
    @Generated
    @JsonCreator
    public static AzureChatExtensionType fromString(String name) {
        return fromString(name, AzureChatExtensionType.class);
    }

    /**
     * Gets known AzureChatExtensionType values.
     *
     * @return known AzureChatExtensionType values.
     */
    @Generated
    public static Collection<AzureChatExtensionType> values() {
        return values(AzureChatExtensionType.class);
    }
}
