// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The state of a job or item. */
public final class AzureOpenAIOperationState extends ExpandableStringEnum<AzureOpenAIOperationState> {

    /** The operation was created and is queued to be processed in the future. */
    @Generated public static final AzureOpenAIOperationState NOT_RUNNING = fromString("notRunning");

    /** The operation has started to be processed. */
    @Generated public static final AzureOpenAIOperationState RUNNING = fromString("running");

    /** The operation has successfully be processed and is ready for consumption. */
    @Generated public static final AzureOpenAIOperationState SUCCEEDED = fromString("succeeded");

    /** The operation has been canceled and is incomplete. */
    @Generated public static final AzureOpenAIOperationState CANCELED = fromString("canceled");

    /** The operation has completed processing with a failure and cannot be further consumed. */
    @Generated public static final AzureOpenAIOperationState FAILED = fromString("failed");

    /**
     * The entity has been deleted but may still be referenced by other entities that originated before the deletion.
     * Note that this state is not used by some Azure OpenAI long-running operations and may not represent a terminal
     * state for those operations.
     */
    @Generated public static final AzureOpenAIOperationState DELETED = fromString("deleted");

    /**
     * Creates a new instance of AzureOpenAIOperationState value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public AzureOpenAIOperationState() {}

    /**
     * Creates or finds a AzureOpenAIOperationState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AzureOpenAIOperationState.
     */
    @Generated
    @JsonCreator
    public static AzureOpenAIOperationState fromString(String name) {
        return fromString(name, AzureOpenAIOperationState.class);
    }

    /**
     * Gets known AzureOpenAIOperationState values.
     *
     * @return known AzureOpenAIOperationState values.
     */
    @Generated
    public static Collection<AzureOpenAIOperationState> values() {
        return values(AzureOpenAIOperationState.class);
    }
}
