// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Content filtering results for a single prompt in the request. */
@Immutable
public final class PromptFilterResult {

    /*
     * The index of this prompt in the set of prompt results
     */
    @Generated
    @JsonProperty(value = "prompt_index")
    private int promptIndex;

    /*
     * Content filtering results for this prompt
     */
    @Generated
    @JsonProperty(value = "content_filter_results")
    private ContentFilterResults contentFilterResults;

    /**
     * Creates an instance of PromptFilterResult class.
     *
     * @param promptIndex the promptIndex value to set.
     */
    @Generated
    @JsonCreator
    private PromptFilterResult(@JsonProperty(value = "prompt_index") int promptIndex) {
        this.promptIndex = promptIndex;
    }

    /**
     * Get the promptIndex property: The index of this prompt in the set of prompt results.
     *
     * @return the promptIndex value.
     */
    @Generated
    public int getPromptIndex() {
        return this.promptIndex;
    }

    /**
     * Get the contentFilterResults property: Content filtering results for this prompt.
     *
     * @return the contentFilterResults value.
     */
    @Generated
    public ContentFilterResults getContentFilterResults() {
        return this.contentFilterResults;
    }
}
