/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.ai.openai.OpenAIServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.polling.SyncPollingStrategy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class OpenAIClientImpl {
    private final OpenAIClientService service;
    private final String endpoint;
    private final OpenAIServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public OpenAIServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public OpenAIClientImpl(String endpoint, OpenAIServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public OpenAIClientImpl(HttpPipeline httpPipeline, String endpoint, OpenAIServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public OpenAIClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, OpenAIServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (OpenAIClientService)RestProxy.create(OpenAIClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEmbeddingsWithResponseAsync(String deploymentOrModelName, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEmbeddings(this.getEndpoint(), this.getServiceVersion().getVersion(), deploymentOrModelName, "application/json", embeddingsOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(String deploymentOrModelName, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getEmbeddingsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), deploymentOrModelName, "application/json", embeddingsOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCompletionsWithResponseAsync(String deploymentOrModelName, BinaryData completionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCompletions(this.getEndpoint(), this.getServiceVersion().getVersion(), deploymentOrModelName, "application/json", completionsOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(String deploymentOrModelName, BinaryData completionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getCompletionsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), deploymentOrModelName, "application/json", completionsOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getChatCompletionsWithResponseAsync(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getChatCompletions(this.getEndpoint(), this.getServiceVersion().getVersion(), deploymentOrModelName, "application/json", chatCompletionsOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getChatCompletionsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), deploymentOrModelName, "application/json", chatCompletionsOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getChatCompletionsWithAzureExtensionsWithResponseAsync(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getChatCompletionsWithAzureExtensions(this.getEndpoint(), this.getServiceVersion().getVersion(), deploymentOrModelName, "application/json", chatCompletionsOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithAzureExtensionsWithResponse(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getChatCompletionsWithAzureExtensionsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), deploymentOrModelName, "application/json", chatCompletionsOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> beginAzureBatchImageGenerationWithResponseAsync(BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.beginAzureBatchImageGeneration(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", imageGenerationOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> beginAzureBatchImageGenerationWithResponse(BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.beginAzureBatchImageGenerationSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", imageGenerationOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBeginAzureBatchImageGenerationAsync(BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.beginAzureBatchImageGenerationWithResponseAsync(imageGenerationOptions, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/openai".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBeginAzureBatchImageGeneration(BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.beginAzureBatchImageGenerationWithResponse(imageGenerationOptions, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/openai".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @Host(value="{endpoint}/openai")
    @ServiceInterface(name="OpenAIClient")
    public static interface OpenAIClientService {
        @Post(value="/deployments/{deploymentId}/embeddings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getEmbeddings(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="deploymentId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/deployments/{deploymentId}/embeddings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getEmbeddingsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="deploymentId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/deployments/{deploymentId}/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCompletions(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="deploymentId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/deployments/{deploymentId}/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCompletionsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="deploymentId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/deployments/{deploymentId}/chat/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getChatCompletions(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="deploymentId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/deployments/{deploymentId}/chat/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getChatCompletionsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="deploymentId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/deployments/{deploymentId}/extensions/chat/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getChatCompletionsWithAzureExtensions(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="deploymentId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/deployments/{deploymentId}/extensions/chat/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getChatCompletionsWithAzureExtensionsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="deploymentId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/images/generations:submit")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> beginAzureBatchImageGeneration(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/images/generations:submit")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> beginAzureBatchImageGenerationSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);
    }
}

