// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai;

import static com.azure.ai.openai.implementation.AudioTranscriptionValidator.validateAudioResponseFormatForTranscription;
import static com.azure.ai.openai.implementation.AudioTranscriptionValidator.validateAudioResponseFormatForTranscriptionText;
import static com.azure.ai.openai.implementation.AudioTranslationValidator.validateAudioResponseFormatForTranslation;
import static com.azure.ai.openai.implementation.AudioTranslationValidator.validateAudioResponseFormatForTranslationText;

import com.azure.ai.openai.implementation.CompletionsUtils;
import com.azure.ai.openai.implementation.MultipartDataHelper;
import com.azure.ai.openai.implementation.MultipartDataSerializationResult;
import com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.models.AudioTranscription;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.azure.ai.openai.models.AudioTranslation;
import com.azure.ai.openai.models.AudioTranslationOptions;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.ai.openai.models.ImageGenerationOptions;
import com.azure.ai.openai.models.ImageOperationResponse;
import com.azure.ai.openai.models.ImageResponse;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

/** Initializes a new instance of the synchronous OpenAIClient type. */
@ServiceClient(builder = OpenAIClientBuilder.class)
public final class OpenAIClient {

    private static final ClientLogger LOGGER = new ClientLogger(OpenAIClient.class);

    @Generated private final OpenAIClientImpl serviceClient;

    private final NonAzureOpenAIClientImpl openAIServiceClient;

    /**
     * Initializes an instance of OpenAIClient class.
     *
     * @param serviceClient the service client implementation.
     */
    OpenAIClient(OpenAIClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        openAIServiceClient = null;
    }

    /**
     * Initializes an instance of OpenAIClient class for NonAzure Implementation.
     *
     * @param serviceClient the service client implementation.
     */
    OpenAIClient(NonAzureOpenAIClientImpl serviceClient) {
        this.serviceClient = null;
        openAIServiceClient = serviceClient;
    }

    /**
     * Return the embeddings for a given prompt.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     user: String (Optional)
     *     model: String (Optional)
     *     input (Required): [
     *         String (Required)
     *     ]
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     data (Required): [
     *          (Required){
     *             embedding (Required): [
     *                 double (Required)
     *             ]
     *             index: int (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param embeddingsOptions The configuration information for an embeddings request. Embeddings measure the
     *     relatedness of text strings and are commonly used for search, clustering, recommendations, and other similar
     *     scenarios.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return representation of the response data from an embeddings request. Embeddings measure the relatedness of
     *     text strings and are commonly used for search, clustering, recommendations, and other similar scenarios along
     *     with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(
            String deploymentOrModelName, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        return openAIServiceClient != null
                ? openAIServiceClient.getEmbeddingsWithResponse(
                        deploymentOrModelName, embeddingsOptions, requestOptions)
                : serviceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptions, requestOptions);
    }

    /**
     * Gets completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     prompt (Required): [
     *         String (Required)
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     logprobs: Integer (Optional)
     *     echo: Boolean (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     best_of: Integer (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             text: String (Required)
     *             index: int (Required)
     *             logprobs (Required): {
     *                 tokens (Required): [
     *                     String (Required)
     *                 ]
     *                 token_logprobs (Required): [
     *                     double (Required)
     *                 ]
     *                 top_logprobs (Required): [
     *                      (Required){
     *                         String: double (Required)
     *                     }
     *                 ]
     *                 text_offset (Required): [
     *                     int (Required)
     *                 ]
     *             }
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request. Completions support a wide
     *     variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     *     that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(
            String deploymentOrModelName, BinaryData completionsOptions, RequestOptions requestOptions) {
        return openAIServiceClient != null
                ? openAIServiceClient.getCompletionsWithResponse(
                        deploymentOrModelName, completionsOptions, requestOptions)
                : serviceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions);
    }

    /**
     * Gets chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     messages (Required): [
     *          (Required){
     *             role: String(system/assistant/user) (Required)
     *             content: String (Optional)
     *         }
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             message (Optional): {
     *                 role: String(system/assistant/user) (Required)
     *                 content: String (Optional)
     *             }
     *             index: int (Required)
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *             delta (Optional): {
     *                 role: String(system/assistant/user) (Optional)
     *                 content: String (Optional)
     *             }
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     *     wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     *     text that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(
            String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return openAIServiceClient != null
                ? openAIServiceClient.getChatCompletionsWithResponse(
                        deploymentOrModelName, chatCompletionsOptions, requestOptions)
                : serviceClient.getChatCompletionsWithResponse(
                        deploymentOrModelName, chatCompletionsOptions, requestOptions);
    }

    /**
     * Return the embeddings for a given prompt.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     user: String (Optional)
     *     model: String (Optional)
     *     input (Required): [
     *         String (Required)
     *     ]
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     data (Required): [
     *          (Required){
     *             embedding (Required): [
     *                 double (Required)
     *             ]
     *             index: int (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param embeddingsOptions The configuration information for an embeddings request. Embeddings measure the
     *     relatedness of text strings and are commonly used for search, clustering, recommendations, and other similar
     *     scenarios.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return representation of the response data from an embeddings request. Embeddings measure the relatedness of
     *     text strings and are commonly used for search, clustering, recommendations, and other similar scenarios along
     *     with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Embeddings> getEmbeddingsWithResponse(
            String deploymentOrModelName, EmbeddingsOptions embeddingsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response =
                getEmbeddingsWithResponse(
                        deploymentOrModelName, BinaryData.fromObject(embeddingsOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(Embeddings.class));
    }

    /**
     * Gets completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     prompt (Required): [
     *         String (Required)
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     logprobs: Integer (Optional)
     *     echo: Boolean (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     best_of: Integer (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             text: String (Required)
     *             index: int (Required)
     *             logprobs (Required): {
     *                 tokens (Required): [
     *                     String (Required)
     *                 ]
     *                 token_logprobs (Required): [
     *                     double (Required)
     *                 ]
     *                 top_logprobs (Required): [
     *                      (Required){
     *                         String: double (Required)
     *                     }
     *                 ]
     *                 text_offset (Required): [
     *                     int (Required)
     *                 ]
     *             }
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request. Completions support a wide
     *     variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     *     that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Completions> getCompletionsWithResponse(
            String deploymentOrModelName, CompletionsOptions completionsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response =
                getCompletionsWithResponse(
                        deploymentOrModelName, BinaryData.fromObject(completionsOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(Completions.class));
    }

    /**
     * Gets chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     messages (Required): [
     *          (Required){
     *             role: String(system/assistant/user) (Required)
     *             content: String (Optional)
     *         }
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             message (Optional): {
     *                 role: String(system/assistant/user) (Required)
     *                 content: String (Optional)
     *             }
     *             index: int (Required)
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *             delta (Optional): {
     *                 role: String(system/assistant/user) (Optional)
     *                 content: String (Optional)
     *             }
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     *     wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     *     text that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ChatCompletions> getChatCompletionsWithResponse(
            String deploymentOrModelName,
            ChatCompletionsOptions chatCompletionsOptions,
            RequestOptions requestOptions) {
        Response<BinaryData> response =
                getChatCompletionsWithResponse(
                        deploymentOrModelName, BinaryData.fromObject(chatCompletionsOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(ChatCompletions.class));
    }

    /**
     * Return the embeddings for a given prompt.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param embeddingsOptions The configuration information for an embeddings request. Embeddings measure the
     *     relatedness of text strings and are commonly used for search, clustering, recommendations, and other similar
     *     scenarios.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return representation of the response data from an embeddings request. Embeddings measure the relatedness of
     *     text strings and are commonly used for search, clustering, recommendations, and other similar scenarios.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Embeddings getEmbeddings(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions) {
        // Generated convenience method for getEmbeddingsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getEmbeddingsWithResponse(
                        deploymentOrModelName, BinaryData.fromObject(embeddingsOptions), requestOptions)
                .getValue()
                .toObject(Embeddings.class);
    }

    /**
     * Gets completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request. Completions support a wide
     *     variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     *     that continues from or "completes" provided prompt data.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        // Generated convenience method for getCompletionsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getCompletionsWithResponse(
                        deploymentOrModelName, BinaryData.fromObject(completionsOptions), requestOptions)
                .getValue()
                .toObject(Completions.class);
    }

    /**
     * Gets completions for the provided input prompt. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param prompt The prompt to generate completion text from.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     *     that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, String prompt) {
        return getCompletions(deploymentOrModelName, CompletionsUtils.defaultCompletionsOptions(prompt));
    }

    /**
     * Gets completions as a stream for the provided input prompts. Completions support a wide variety of tasks and
     * generate text that continues from or "completes" provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request. Completions support a wide
     *     variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an {@link IterableStream} of completions for the provided input prompts. Completions support a wide
     *     variety of tasks and generate text that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public IterableStream<Completions> getCompletionsStream(
            String deploymentOrModelName, CompletionsOptions completionsOptions) {
        completionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux<ByteBuffer> responseStream =
                getCompletionsWithResponse(
                                deploymentOrModelName, BinaryData.fromObject(completionsOptions), requestOptions)
                        .getValue()
                        .toFluxByteBuffer();
        OpenAIServerSentEvents<Completions> completionsStream =
                new OpenAIServerSentEvents<>(responseStream, Completions.class);
        return new IterableStream<>(completionsStream.getEvents());
    }

    /**
     * Gets chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     *     wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     *     text that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ChatCompletions getChatCompletions(
            String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        if (chatCompletionsOptions.getDataSources() == null || chatCompletionsOptions.getDataSources().isEmpty()) {
            return getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions, requestOptions)
                    .getValue();
        } else {
            return getChatCompletionsWithAzureExtensionsWithResponse(
                            deploymentOrModelName, BinaryData.fromObject(chatCompletionsOptions), requestOptions)
                    .getValue()
                    .toObject(ChatCompletions.class);
        }
    }

    /**
     * Gets chat completions for the provided chat messages. Chat completions support a wide variety of tasks and
     * generate text that continues from or "completes" provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     *     wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return chat completions stream for the provided chat messages. Completions support a wide variety of tasks and
     *     generate text that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public IterableStream<ChatCompletions> getChatCompletionsStream(
            String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        chatCompletionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux<ByteBuffer> responseStream;
        if (chatCompletionsOptions.getDataSources() == null || chatCompletionsOptions.getDataSources().isEmpty()) {
            responseStream =
                    getChatCompletionsWithResponse(
                                    deploymentOrModelName,
                                    BinaryData.fromObject(chatCompletionsOptions),
                                    requestOptions)
                            .getValue()
                            .toFluxByteBuffer();
        } else {
            responseStream =
                    getChatCompletionsWithAzureExtensionsWithResponse(
                                    deploymentOrModelName,
                                    BinaryData.fromObject(chatCompletionsOptions),
                                    requestOptions)
                            .getValue()
                            .toFluxByteBuffer();
        }
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream =
                new OpenAIServerSentEvents<>(responseStream, ChatCompletions.class);
        return new IterableStream<>(chatCompletionsStream.getEvents());
    }

    /**
     * Starts the generation of a batch of images from a text caption.
     *
     * @param imageGenerationOptions Represents the request data used to generate images.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ImageResponse} for the image generation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ImageResponse getImages(ImageGenerationOptions imageGenerationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        BinaryData imageGenerationOptionsBinaryData = BinaryData.fromObject(imageGenerationOptions);
        if (openAIServiceClient != null) {
            return openAIServiceClient
                    .generateImageWithResponse(imageGenerationOptionsBinaryData, requestOptions)
                    .getValue()
                    .toObject(ImageResponse.class);
        } else {
            return beginBeginAzureBatchImageGeneration(imageGenerationOptionsBinaryData, requestOptions)
                    .getFinalResult()
                    .toObject(ImageOperationResponse.class)
                    .getResult();
        }
    }

    /**
     * Starts the generation of a batch of images from a text caption.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     prompt: String (Required)
     *     n: Integer (Optional)
     *     size: String(256x256/512x512/1024x1024) (Optional)
     *     response_format: String(url/b64_json) (Optional)
     *     user: String (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: long (Required)
     *     expires: Long (Optional)
     *     result (Optional): {
     *         created: long (Required)
     *         data: DataModelBase (Required)
     *     }
     *     status: String(notRunning/running/succeeded/canceled/failed) (Required)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }</pre>
     *
     * @param imageGenerationOptions Represents the request data used to generate images.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of a polling status update or final response payload for an image
     *     operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<BinaryData, BinaryData> beginBeginAzureBatchImageGeneration(
            BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        return this.serviceClient.beginBeginAzureBatchImageGeneration(imageGenerationOptions, requestOptions);
    }

    /**
     * Gets chat completions for the provided chat messages. This is an Azure-specific version of chat completions that
     * supports integration with configured data sources and other augmentations to the base chat completions
     * capabilities.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     messages (Required): [
     *          (Required){
     *             role: String(system/assistant/user/function/tool) (Required)
     *             content: String (Required)
     *             name: String (Optional)
     *             function_call (Optional): {
     *                 name: String (Required)
     *                 arguments: String (Required)
     *             }
     *             context (Optional): {
     *                 messages (Optional): [
     *                     (recursive schema, see above)
     *                 ]
     *             }
     *         }
     *     ]
     *     functions (Optional): [
     *          (Optional){
     *             name: String (Required)
     *             description: String (Optional)
     *             parameters: Object (Optional)
     *         }
     *     ]
     *     function_call: FunctionCallModelBase (Optional)
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     *     dataSources (Optional): [
     *          (Optional){
     *             type: String(AzureCognitiveSearch) (Required)
     *             parameters: Object (Required)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: long (Required)
     *     choices (Required): [
     *          (Required){
     *             message (Optional): {
     *                 role: String(system/assistant/user/function/tool) (Required)
     *                 content: String (Required)
     *                 name: String (Optional)
     *                 function_call (Optional): {
     *                     name: String (Required)
     *                     arguments: String (Required)
     *                 }
     *                 context (Optional): {
     *                     messages (Optional): [
     *                         (recursive schema, see above)
     *                     ]
     *                 }
     *             }
     *             index: int (Required)
     *             finish_reason: String(stop/length/content_filter/function_call) (Required)
     *             delta (Optional): (recursive schema, see delta above)
     *             content_filter_results (Optional): {
     *                 sexual (Optional): {
     *                     severity: String(safe/low/medium/high) (Required)
     *                     filtered: boolean (Required)
     *                 }
     *                 violence (Optional): (recursive schema, see violence above)
     *                 hate (Optional): (recursive schema, see hate above)
     *                 self_harm (Optional): (recursive schema, see self_harm above)
     *                 error (Optional): {
     *                     code: String (Required)
     *                     message: String (Required)
     *                     target: String (Optional)
     *                     details (Optional): [
     *                         (recursive schema, see above)
     *                     ]
     *                     innererror (Optional): {
     *                         code: String (Optional)
     *                         innererror (Optional): (recursive schema, see innererror above)
     *                     }
     *                 }
     *             }
     *         }
     *     ]
     *     prompt_filter_results (Optional): [
     *          (Optional){
     *             prompt_index: int (Required)
     *             content_filter_results (Optional): (recursive schema, see content_filter_results above)
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     *     wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return chat completions for the provided chat messages. This is an Azure-specific version of chat completions
     *     that supports integration with configured data sources and other augmentations to the base chat completions
     *     capabilities along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getChatCompletionsWithAzureExtensionsWithResponse(
            String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return this.serviceClient.getChatCompletionsWithAzureExtensionsWithResponse(
                deploymentOrModelName, chatCompletionsOptions, requestOptions);
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranscription} transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AudioTranscription getAudioTranscription(
            String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return getAudioTranscriptionWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null)
                .getValue();
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranscription} transcribed text and associated metadata from provided spoken audio data along
     *     with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AudioTranscription> getAudioTranscriptionWithResponse(
            String deploymentOrModelName,
            String fileName,
            AudioTranscriptionOptions audioTranscriptionOptions,
            RequestOptions requestOptions) {
        // checking allowed formats for a JSON response
        validateAudioResponseFormatForTranscription(audioTranscriptionOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        final MultipartDataHelper helper = new MultipartDataHelper();
        final MultipartDataSerializationResult result = helper.serializeRequest(audioTranscriptionOptions, fileName);
        final BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response =
                openAIServiceClient != null
                        ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponse(
                                deploymentOrModelName, data, requestOptions)
                        : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(
                                deploymentOrModelName, data, requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(AudioTranscription.class));
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranscriptionText(
            String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return getAudioTranscriptionTextWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null)
                .getValue();
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<String> getAudioTranscriptionTextWithResponse(
            String deploymentOrModelName,
            String fileName,
            AudioTranscriptionOptions audioTranscriptionOptions,
            RequestOptions requestOptions) {
        // checking allowed formats for a plain text response
        validateAudioResponseFormatForTranscriptionText(audioTranscriptionOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        final MultipartDataHelper helper = new MultipartDataHelper();
        final MultipartDataSerializationResult result = helper.serializeRequest(audioTranscriptionOptions, fileName);
        final BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response =
                openAIServiceClient != null
                        ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponse(
                                deploymentOrModelName, data, requestOptions)
                        : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(
                                deploymentOrModelName, data, requestOptions);
        return new SimpleResponse<>(response, response.getValue().toString());
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranscription} english language transcribed text and associated metadata from provided spoken
     *     audio file data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AudioTranslation getAudioTranslation(
            String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions) {
        return getAudioTranslationWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null)
                .getValue();
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranslation} english language transcribed text and associated metadata from provided spoken
     *     audio file data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AudioTranslation> getAudioTranslationWithResponse(
            String deploymentOrModelName,
            String fileName,
            AudioTranslationOptions audioTranslationOptions,
            RequestOptions requestOptions) {
        // checking allowed formats for a JSON response
        validateAudioResponseFormatForTranslation(audioTranslationOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        final MultipartDataHelper helper = new MultipartDataHelper();
        final MultipartDataSerializationResult result = helper.serializeRequest(audioTranslationOptions, fileName);
        final BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response =
                openAIServiceClient != null
                        ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponse(
                                deploymentOrModelName, data, requestOptions)
                        : this.serviceClient.getAudioTranslationAsPlainTextWithResponse(
                                deploymentOrModelName, data, requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(AudioTranslation.class));
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio file data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranslationText(
            String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions) {
        return getAudioTranslationTextWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null)
                .getValue();
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio file data along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<String> getAudioTranslationTextWithResponse(
            String deploymentOrModelName,
            String fileName,
            AudioTranslationOptions audioTranslationOptions,
            RequestOptions requestOptions) {
        // checking allowed formats for a plain text response
        validateAudioResponseFormatForTranslationText(audioTranslationOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        final MultipartDataHelper helper = new MultipartDataHelper();
        final MultipartDataSerializationResult result = helper.serializeRequest(audioTranslationOptions, fileName);
        final BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response =
                openAIServiceClient != null
                        ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponse(
                                deploymentOrModelName, data, requestOptions)
                        : this.serviceClient.getAudioTranslationAsPlainTextWithResponse(
                                deploymentOrModelName, data, requestOptions);
        return new SimpleResponse<>(response, response.getValue().toString());
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     file: byte[] (Required)
     *     response_format: String(json/verbose_json/text/srt/vtt) (Optional)
     *     language: String (Optional)
     *     prompt: String (Optional)
     *     temperature: Double (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     text: String (Required)
     *     task: String(transcribe/translate) (Optional)
     *     language: String (Optional)
     *     duration: Double (Optional)
     *     segments (Optional): [
     *          (Optional){
     *             id: int (Required)
     *             start: double (Required)
     *             end: double (Required)
     *             text: String (Required)
     *             temperature: double (Required)
     *             avg_logprob: double (Required)
     *             compression_ratio: double (Required)
     *             no_speech_prob: double (Required)
     *             tokens (Required): [
     *                 int (Required)
     *             ]
     *             seek: int (Required)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return transcribed text and associated metadata from provided spoken audio data along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranscriptionAsResponseObjectWithResponse(
            String deploymentOrModelName, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranscriptionAsResponseObjectWithResponse(
                deploymentOrModelName, audioTranscriptionOptions, requestOptions);
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     file: byte[] (Required)
     *     response_format: String(json/verbose_json/text/srt/vtt) (Optional)
     *     language: String (Optional)
     *     prompt: String (Optional)
     *     temperature: Double (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * String
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return transcribed text and associated metadata from provided spoken audio data along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranscriptionAsPlainTextWithResponse(
            String deploymentOrModelName, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(
                deploymentOrModelName, audioTranscriptionOptions, requestOptions);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     file: byte[] (Required)
     *     response_format: String(json/verbose_json/text/srt/vtt) (Optional)
     *     prompt: String (Optional)
     *     temperature: Double (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     text: String (Required)
     *     task: String(transcribe/translate) (Optional)
     *     language: String (Optional)
     *     duration: Double (Optional)
     *     segments (Optional): [
     *          (Optional){
     *             id: int (Required)
     *             start: double (Required)
     *             end: double (Required)
     *             text: String (Required)
     *             temperature: double (Required)
     *             avg_logprob: double (Required)
     *             compression_ratio: double (Required)
     *             no_speech_prob: double (Required)
     *             tokens (Required): [
     *                 int (Required)
     *             ]
     *             seek: int (Required)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return english language transcribed text and associated metadata from provided spoken audio data along with
     *     {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranslationAsResponseObjectWithResponse(
            String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranslationAsResponseObjectWithResponse(
                deploymentOrModelName, audioTranslationOptions, requestOptions);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     file: byte[] (Required)
     *     response_format: String(json/verbose_json/text/srt/vtt) (Optional)
     *     prompt: String (Optional)
     *     temperature: Double (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * String
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return english language transcribed text and associated metadata from provided spoken audio data along with
     *     {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranslationAsPlainTextWithResponse(
            String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranslationAsPlainTextWithResponse(
                deploymentOrModelName, audioTranslationOptions, requestOptions);
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AudioTranscription getAudioTranscriptionAsResponseObject(
            String deploymentOrModelName, AudioTranscriptionOptions audioTranscriptionOptions) {
        // Generated convenience method for getAudioTranscriptionAsResponseObjectWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getAudioTranscriptionAsResponseObjectWithResponse(
                        deploymentOrModelName, BinaryData.fromObject(audioTranscriptionOptions), requestOptions)
                .getValue()
                .toObject(AudioTranscription.class);
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranscriptionAsPlainText(
            String deploymentOrModelName, AudioTranscriptionOptions audioTranscriptionOptions) {
        // Generated convenience method for getAudioTranscriptionAsPlainTextWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getAudioTranscriptionAsPlainTextWithResponse(
                        deploymentOrModelName, BinaryData.fromObject(audioTranscriptionOptions), requestOptions)
                .getValue()
                .toObject(String.class);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio data.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AudioTranslation getAudioTranslationAsResponseObject(
            String deploymentOrModelName, AudioTranslationOptions audioTranslationOptions) {
        // Generated convenience method for getAudioTranslationAsResponseObjectWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getAudioTranslationAsResponseObjectWithResponse(
                        deploymentOrModelName, BinaryData.fromObject(audioTranslationOptions), requestOptions)
                .getValue()
                .toObject(AudioTranslation.class);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     *     (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio data.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranslationAsPlainText(
            String deploymentOrModelName, AudioTranslationOptions audioTranslationOptions) {
        // Generated convenience method for getAudioTranslationAsPlainTextWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getAudioTranslationAsPlainTextWithResponse(
                        deploymentOrModelName, BinaryData.fromObject(audioTranslationOptions), requestOptions)
                .getValue()
                .toObject(String.class);
    }
}
