// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;

/** Result information for an operation that translated spoken audio into written text. */
@Immutable
public final class AudioTranslation {

    /*
     * The translated text for the provided audio data.
     */
    @Generated
    @JsonProperty(value = "text")
    private String text;

    /*
     * The label that describes which operation type generated the accompanying response data.
     */
    @Generated
    @JsonProperty(value = "task")
    private AudioTaskLabel task;

    /*
     * The spoken language that was detected in the translated audio data.
     * This is expressed as a two-letter ISO-639-1 language code like 'en' or 'fr'.
     */
    @Generated
    @JsonProperty(value = "language")
    private String language;

    /*
     * The total duration of the audio processed to produce accompanying translation information.
     */
    @Generated
    @JsonProperty(value = "duration")
    private Double duration;

    /*
     * A collection of information about the timing, probabilities, and other detail of each processed audio segment.
     */
    @Generated
    @JsonProperty(value = "segments")
    private List<AudioTranslationSegment> segments;

    /**
     * Creates an instance of AudioTranslation class.
     *
     * @param text the text value to set.
     */
    @Generated
    @JsonCreator
    private AudioTranslation(@JsonProperty(value = "text") String text) {
        this.text = text;
    }

    /**
     * Get the text property: The translated text for the provided audio data.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the task property: The label that describes which operation type generated the accompanying response data.
     *
     * @return the task value.
     */
    @Generated
    public AudioTaskLabel getTask() {
        return this.task;
    }

    /**
     * Get the language property: The spoken language that was detected in the translated audio data. This is expressed
     * as a two-letter ISO-639-1 language code like 'en' or 'fr'.
     *
     * @return the language value.
     */
    @Generated
    public String getLanguage() {
        return this.language;
    }

    /**
     * Get the duration property: The total duration of the audio processed to produce accompanying translation
     * information.
     *
     * @return the duration value.
     */
    @Generated
    public Duration getDuration() {
        if (this.duration == null) {
            return null;
        }
        return Duration.ofNanos((long) (this.duration * 1000_000_000L));
    }

    /**
     * Get the segments property: A collection of information about the timing, probabilities, and other detail of each
     * processed audio segment.
     *
     * @return the segments value.
     */
    @Generated
    public List<AudioTranslationSegment> getSegments() {
        return this.segments;
    }
}
