// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A representation of configuration data for a single Azure OpenAI chat extension. This will be used by a chat
 * completions request that should use Azure OpenAI chat extensions to augment the response behavior. The use of this
 * configuration is compatible only with Azure OpenAI.
 */
@Immutable
public final class AzureChatExtensionConfiguration {

    /*
     * The label for the type of an Azure chat extension. This typically corresponds to a matching Azure resource.
     * Azure chat extensions are only compatible with Azure OpenAI.
     */
    @Generated
    @JsonProperty(value = "type")
    private AzureChatExtensionType type;

    /*
     * The configuration payload used for the Azure chat extension. The structure payload details are specific to the
     * extension being configured.
     * Azure chat extensions are only compatible with Azure OpenAI.
     */
    @Generated
    @JsonProperty(value = "parameters")
    private Object parameters;

    /**
     * Creates an instance of AzureChatExtensionConfiguration class.
     *
     * @param type the type value to set.
     * @param parameters the parameters value to set.
     */
    @Generated
    @JsonCreator
    public AzureChatExtensionConfiguration(
            @JsonProperty(value = "type") AzureChatExtensionType type,
            @JsonProperty(value = "parameters") Object parameters) {
        this.type = type;
        this.parameters = parameters;
    }

    /**
     * Get the type property: The label for the type of an Azure chat extension. This typically corresponds to a
     * matching Azure resource. Azure chat extensions are only compatible with Azure OpenAI.
     *
     * @return the type value.
     */
    @Generated
    public AzureChatExtensionType getType() {
        return this.type;
    }

    /**
     * Get the parameters property: The configuration payload used for the Azure chat extension. The structure payload
     * details are specific to the extension being configured. Azure chat extensions are only compatible with Azure
     * OpenAI.
     *
     * @return the parameters value.
     */
    @Generated
    public Object getParameters() {
        return this.parameters;
    }
}
