// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A specific representation of configurable options for Azure Cognitive Search when using it as an Azure OpenAI chat
 * extension.
 */
public class AzureCognitiveSearchChatExtensionConfiguration {

    /*
     * The absolute endpoint path for the Azure Cognitive Search resource to use.
     */
    @JsonProperty(value = "endpoint")
    private String endpoint;

    /*
     * The API key to use with the specified Azure Cognitive Search endpoint.
     */
    @JsonProperty(value = "key")
    private String key;

    /*
     * The name of the index to use as available in the referenced Azure Cognitive Search resource.
     */
    @JsonProperty(value = "indexName")
    private String indexName;

    /**
     * Creates an instance of AzureCognitiveSearchChatExtensionConfiguration
     *
     * @param endpoint absolute path for the Azure Cognitive Search resource
     * @param key the API key for the Azure Cognitive search endpoint
     * @param indexName the name of the index to use in the referenced Azure Cognitive Search resource
     */
    @JsonCreator
    public AzureCognitiveSearchChatExtensionConfiguration(
        @JsonProperty(value = "endpoint") String endpoint,
        @JsonProperty(value = "key") String key,
        @JsonProperty(value = "indexName") String indexName) {
        this.endpoint = endpoint;
        this.key = key;
        this.indexName = indexName;
    }

    /**
     * Gets the endpoint of this Azure Cognitive Search resource configuration
     *
     * @return The endpoint value as a String
     */
    public String getEndpoint() {
        return endpoint;
    }

    /**
     * Sets the endpoint of this Azure Cognitive Search resource configuration
     *
     * @param endpoint String URL representing the endpoint
     * @return the AzureCognitiveSearchChatExtensionConfiguration object itself
     */
    public AzureCognitiveSearchChatExtensionConfiguration setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    /**
     * Gets the Azure Cognitive Search API key value as a String
     *
     * @return the value of the API key as a String
     */
    public String getKey() {
        return key;
    }

    /**
     * Sets the Azure Cognitive Search API key value as a String
     *
     * @param key the value of the key for the resource
     * @return the AzureCognitiveSearchChatExtensionConfiguration object itself
     */
    public AzureCognitiveSearchChatExtensionConfiguration setKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Gets the Index Name of the document of the Azure Cognitive Search resource
     *
     * @return the Index Name of the document as a String
     */
    public String getIndexName() {
        return indexName;
    }

    /**
     * Sets the Index Name of the document of the Azure Cognitive Search resource
     *
     * @param indexName the Index Name of the document as a String
     * @return the AzureCognitiveSearchChatExtensionConfiguration object itself
     */
    public AzureCognitiveSearchChatExtensionConfiguration setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }
}
