// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The representation of a single prompt completion as part of an overall chat completions request. Generally, `n`
 * choices are generated per provided prompt with a default value of 1. Token limits and other settings may limit the
 * number of choices generated.
 */
@Immutable
public final class ChatChoice {

    /*
     * The chat message for a given chat completions prompt.
     */
    @Generated
    @JsonProperty(value = "message")
    private ChatMessage message;

    /*
     * The ordered index associated with this chat completions choice.
     */
    @Generated
    @JsonProperty(value = "index")
    private int index;

    /*
     * The reason that this chat completions choice completed its generated.
     */
    @Generated
    @JsonProperty(value = "finish_reason")
    private CompletionsFinishReason finishReason;

    /*
     * The delta message content for a streaming response.
     */
    @Generated
    @JsonProperty(value = "delta")
    private ChatMessage delta;

    /**
     * Creates an instance of ChatChoice class.
     *
     * @param index the index value to set.
     * @param finishReason the finishReason value to set.
     */
    @Generated
    @JsonCreator
    private ChatChoice(
            @JsonProperty(value = "index") int index,
            @JsonProperty(value = "finish_reason") CompletionsFinishReason finishReason) {
        this.index = index;
        this.finishReason = finishReason;
    }

    /**
     * Get the message property: The chat message for a given chat completions prompt.
     *
     * @return the message value.
     */
    @Generated
    public ChatMessage getMessage() {
        return this.message;
    }

    /**
     * Get the index property: The ordered index associated with this chat completions choice.
     *
     * @return the index value.
     */
    @Generated
    public int getIndex() {
        return this.index;
    }

    /**
     * Get the finishReason property: The reason that this chat completions choice completed its generated.
     *
     * @return the finishReason value.
     */
    @Generated
    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }

    /**
     * Get the delta property: The delta message content for a streaming response.
     *
     * @return the delta value.
     */
    @Generated
    public ChatMessage getDelta() {
        return this.delta;
    }

    /*
     * Information about the content filtering category (hate, sexual, violence, self_harm), if it
     * has been detected, as well as the severity level (very_low, low, medium, high-scale that
     * determines the intensity and risk level of harmful content) and if it has been filtered or not.
     */
    @Generated
    @JsonProperty(value = "content_filter_results")
    private ContentFilterResults contentFilterResults;

    /**
     * Get the contentFilterResults property: Information about the content filtering category (hate, sexual, violence,
     * self_harm), if it has been detected, as well as the severity level (very_low, low, medium, high-scale that
     * determines the intensity and risk level of harmful content) and if it has been filtered or not.
     *
     * @return the contentFilterResults value.
     */
    @Generated
    public ContentFilterResults getContentFilterResults() {
        return this.contentFilterResults;
    }
}
