// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The result of the operation if the operation succeeded. */
@Immutable
public final class ImageResponse {

    /*
     * A timestamp when this job or item was created (in unix epochs).
     */
    @Generated
    @JsonProperty(value = "created")
    private long created;

    /*
     * The images generated by the operator.
     */
    @Generated
    @JsonProperty(value = "data")
    private List<ImageLocation> data;

    /**
     * Creates an instance of ImageResponse class.
     *
     * @param created the created value to set.
     * @param data the data value to set.
     */
    @Generated
    @JsonCreator
    private ImageResponse(
            @JsonProperty(value = "created") long created, @JsonProperty(value = "data") List<ImageLocation> data) {
        this.created = created;
        this.data = data;
    }

    /**
     * Get the created property: A timestamp when this job or item was created (in unix epochs).
     *
     * @return the created value.
     */
    @Generated
    public long getCreated() {
        return this.created;
    }

    /**
     * Get the data property: The images generated by the operator.
     *
     * @return the data value.
     */
    @Generated
    public List<ImageLocation> getData() {
        return this.data;
    }
}
