// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The desired size of the generated images. Must be one of 256x256, 512x512, or 1024x1024. */
public final class ImageSize extends ExpandableStringEnum<ImageSize> {

    /** Image size of 256x256. */
    @Generated public static final ImageSize SIZE256X256 = fromString("256x256");

    /** Image size of 512x512. */
    @Generated public static final ImageSize SIZE512X512 = fromString("512x512");

    /** Image size of 1024x1024. */
    @Generated public static final ImageSize SIZE1024X1024 = fromString("1024x1024");

    /**
     * Creates a new instance of ImageSize value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ImageSize() {}

    /**
     * Creates or finds a ImageSize from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ImageSize.
     */
    @Generated
    @JsonCreator
    public static ImageSize fromString(String name) {
        return fromString(name, ImageSize.class);
    }

    /**
     * Gets known ImageSize values.
     *
     * @return known ImageSize values.
     */
    @Generated
    public static Collection<ImageSize> values() {
        return values(ImageSize.class);
    }
}
