/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai;

import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.implementation.AudioTranscriptionValidator;
import com.azure.ai.openai.implementation.AudioTranslationValidator;
import com.azure.ai.openai.implementation.CompletionsUtils;
import com.azure.ai.openai.implementation.MultipartDataHelper;
import com.azure.ai.openai.implementation.MultipartDataSerializationResult;
import com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.models.AudioTranscription;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.azure.ai.openai.models.AudioTranslation;
import com.azure.ai.openai.models.AudioTranslationOptions;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.ai.openai.models.ImageGenerationOptions;
import com.azure.ai.openai.models.ImageOperationResponse;
import com.azure.ai.openai.models.ImageResponse;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=OpenAIClientBuilder.class, isAsync=true)
public final class OpenAIAsyncClient {
    private final OpenAIClientImpl serviceClient;
    private static final ClientLogger LOGGER = new ClientLogger(OpenAIAsyncClient.class);
    private final NonAzureOpenAIClientImpl openAIServiceClient;

    OpenAIAsyncClient(OpenAIClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.openAIServiceClient = null;
    }

    OpenAIAsyncClient(NonAzureOpenAIClientImpl serviceClient) {
        this.serviceClient = null;
        this.openAIServiceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEmbeddingsWithResponse(String deploymentOrModelName, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getEmbeddingsWithResponseAsync(deploymentOrModelName, embeddingsOptions, requestOptions) : this.serviceClient.getEmbeddingsWithResponseAsync(deploymentOrModelName, embeddingsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCompletionsWithResponse(String deploymentOrModelName, BinaryData completionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getCompletionsWithResponseAsync(deploymentOrModelName, completionsOptions, requestOptions) : this.serviceClient.getCompletionsWithResponseAsync(deploymentOrModelName, completionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getChatCompletionsWithResponse(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getChatCompletionsWithResponseAsync(deploymentOrModelName, chatCompletionsOptions, requestOptions) : this.serviceClient.getChatCompletionsWithResponseAsync(deploymentOrModelName, chatCompletionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Embeddings>> getEmbeddingsWithResponse(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions, RequestOptions requestOptions) {
        return this.getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)embeddingsOptions), requestOptions).map(response -> new SimpleResponse(response, (Object)((Embeddings)((BinaryData)response.getValue()).toObject(Embeddings.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Completions>> getCompletionsWithResponse(String deploymentOrModelName, CompletionsOptions completionsOptions, RequestOptions requestOptions) {
        return this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).map(response -> new SimpleResponse(response, (Object)((Completions)((BinaryData)response.getValue()).toObject(Completions.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ChatCompletions>> getChatCompletionsWithResponse(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions, RequestOptions requestOptions) {
        return this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).map(response -> new SimpleResponse(response, (Object)((ChatCompletions)((BinaryData)response.getValue()).toObject(ChatCompletions.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Embeddings> getEmbeddings(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)embeddingsOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Embeddings)protocolMethodData.toObject(Embeddings.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Completions> getCompletions(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Completions)protocolMethodData.toObject(Completions.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Completions> getCompletions(String deploymentOrModelName, String prompt) {
        return this.getCompletions(deploymentOrModelName, CompletionsUtils.defaultCompletionsOptions(prompt));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<Completions> getCompletionsStream(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        completionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        BinaryData requestBody = BinaryData.fromObject((Object)completionsOptions);
        Flux responseStream = this.getCompletionsWithResponse(deploymentOrModelName, requestBody, requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents<Completions> completionsStream = new OpenAIServerSentEvents<Completions>((Flux<ByteBuffer>)responseStream, Completions.class);
        return completionsStream.getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ChatCompletions> getChatCompletions(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        if (chatCompletionsOptions.getDataSources() == null || chatCompletionsOptions.getDataSources().isEmpty()) {
            return this.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions, requestOptions).flatMap(FluxUtil::toMono);
        }
        return this.getChatCompletionsWithAzureExtensionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ChatCompletions)protocolMethodData.toObject(ChatCompletions.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<ChatCompletions> getChatCompletionsStream(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        chatCompletionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = chatCompletionsOptions.getDataSources() == null || chatCompletionsOptions.getDataSources().isEmpty() ? this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer()) : this.getChatCompletionsWithAzureExtensionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream = new OpenAIServerSentEvents<ChatCompletions>((Flux<ByteBuffer>)responseStream, ChatCompletions.class);
        return chatCompletionsStream.getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ImageResponse> getImages(ImageGenerationOptions imageGenerationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        BinaryData imageGenerationOptionsBinaryData = BinaryData.fromObject((Object)imageGenerationOptions);
        return this.openAIServiceClient != null ? this.openAIServiceClient.generateImageWithResponseAsync(imageGenerationOptionsBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(it -> (ImageResponse)it.toObject(ImageResponse.class)) : this.beginBeginAzureBatchImageGeneration(imageGenerationOptionsBinaryData, requestOptions).last().flatMap(it -> it.getFinalResult()).map(it -> ((ImageOperationResponse)it.toObject(ImageOperationResponse.class)).getResult());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<BinaryData, BinaryData> beginBeginAzureBatchImageGeneration(BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        return this.serviceClient.beginBeginAzureBatchImageGenerationAsync(imageGenerationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> getChatCompletionsWithAzureExtensionsWithResponse(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return this.serviceClient.getChatCompletionsWithAzureExtensionsWithResponseAsync(deploymentOrModelName, chatCompletionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranscriptionAsResponseObjectWithResponse(String deploymentOrModelName, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranscriptionAsResponseObjectWithResponseAsync(deploymentOrModelName, audioTranscriptionOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AudioTranscription> getAudioTranscription(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return this.getAudioTranscriptionWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AudioTranscription>> getAudioTranscriptionWithResponse(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        try {
            AudioTranscriptionValidator.validateAudioResponseFormatForTranscription(audioTranscriptionOptions);
        }
        catch (IllegalArgumentException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        MultipartDataHelper helper = new MultipartDataHelper();
        MultipartDataSerializationResult result = helper.serializeRequest(audioTranscriptionOptions, fileName);
        BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Mono<Response<BinaryData>> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranscriptionAsResponseObjectWithResponseAsync(deploymentOrModelName, data, requestOptions) : this.serviceClient.getAudioTranscriptionAsResponseObjectWithResponseAsync(deploymentOrModelName, data, requestOptions);
        return response.map(responseBinaryData -> new SimpleResponse(responseBinaryData, (Object)((AudioTranscription)((BinaryData)responseBinaryData.getValue()).toObject(AudioTranscription.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getAudioTranscriptionText(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return this.getAudioTranscriptionTextWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> getAudioTranscriptionTextWithResponse(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        try {
            AudioTranscriptionValidator.validateAudioResponseFormatForTranscriptionText(audioTranscriptionOptions);
        }
        catch (IllegalArgumentException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        MultipartDataHelper helper = new MultipartDataHelper();
        MultipartDataSerializationResult result = helper.serializeRequest(audioTranscriptionOptions, fileName);
        BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Mono<Response<BinaryData>> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponseAsync(deploymentOrModelName, data, requestOptions) : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponseAsync(deploymentOrModelName, data, requestOptions);
        return response.map(dataResponse -> new SimpleResponse(dataResponse, (Object)((BinaryData)dataResponse.getValue()).toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AudioTranslation> getAudioTranslation(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions) {
        return this.getAudioTranslationWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AudioTranslation>> getAudioTranslationWithResponse(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        try {
            AudioTranslationValidator.validateAudioResponseFormatForTranslation(audioTranslationOptions);
        }
        catch (IllegalArgumentException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        MultipartDataHelper helper = new MultipartDataHelper();
        MultipartDataSerializationResult result = helper.serializeRequest(audioTranslationOptions, fileName);
        BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Mono<Response<BinaryData>> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranslationAsResponseObjectWithResponseAsync(deploymentOrModelName, data, requestOptions) : this.serviceClient.getAudioTranslationAsResponseObjectWithResponseAsync(deploymentOrModelName, data, requestOptions);
        return response.map(responseBinaryData -> new SimpleResponse(responseBinaryData, (Object)((AudioTranslation)((BinaryData)responseBinaryData.getValue()).toObject(AudioTranslation.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getAudioTranslationText(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions) {
        return this.getAudioTranslationTextWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> getAudioTranslationTextWithResponse(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        try {
            AudioTranslationValidator.validateAudioResponseFormatForTranslationText(audioTranslationOptions);
        }
        catch (IllegalArgumentException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        MultipartDataHelper helper = new MultipartDataHelper();
        MultipartDataSerializationResult result = helper.serializeRequest(audioTranslationOptions, fileName);
        BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Mono<Response<BinaryData>> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponseAsync(deploymentOrModelName, data, requestOptions) : this.serviceClient.getAudioTranslationAsPlainTextWithResponseAsync(deploymentOrModelName, data, requestOptions);
        return response.map(responseBinaryData -> new SimpleResponse(responseBinaryData, (Object)((BinaryData)responseBinaryData.getValue()).toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranscriptionAsPlainTextWithResponse(String deploymentOrModelName, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranscriptionAsPlainTextWithResponseAsync(deploymentOrModelName, audioTranscriptionOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranslationAsResponseObjectWithResponse(String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranslationAsResponseObjectWithResponseAsync(deploymentOrModelName, audioTranslationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranslationAsPlainTextWithResponse(String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranslationAsPlainTextWithResponseAsync(deploymentOrModelName, audioTranslationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AudioTranscription> getAudioTranscriptionAsResponseObject(String deploymentOrModelName, AudioTranscriptionOptions audioTranscriptionOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAudioTranscriptionAsResponseObjectWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranscriptionOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AudioTranscription)protocolMethodData.toObject(AudioTranscription.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getAudioTranscriptionAsPlainText(String deploymentOrModelName, AudioTranscriptionOptions audioTranscriptionOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranscriptionOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (String)protocolMethodData.toObject(String.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AudioTranslation> getAudioTranslationAsResponseObject(String deploymentOrModelName, AudioTranslationOptions audioTranslationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAudioTranslationAsResponseObjectWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranslationOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AudioTranslation)protocolMethodData.toObject(AudioTranslation.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getAudioTranslationAsPlainText(String deploymentOrModelName, AudioTranslationOptions audioTranslationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranslationOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (String)protocolMethodData.toObject(String.class));
    }
}

