/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai;

import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.implementation.AudioTranscriptionValidator;
import com.azure.ai.openai.implementation.AudioTranslationValidator;
import com.azure.ai.openai.implementation.CompletionsUtils;
import com.azure.ai.openai.implementation.MultipartDataHelper;
import com.azure.ai.openai.implementation.MultipartDataSerializationResult;
import com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.models.AudioTranscription;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.azure.ai.openai.models.AudioTranslation;
import com.azure.ai.openai.models.AudioTranslationOptions;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.ai.openai.models.ImageGenerationOptions;
import com.azure.ai.openai.models.ImageOperationResponse;
import com.azure.ai.openai.models.ImageResponse;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

@ServiceClient(builder=OpenAIClientBuilder.class)
public final class OpenAIClient {
    private static final ClientLogger LOGGER = new ClientLogger(OpenAIClient.class);
    private final OpenAIClientImpl serviceClient;
    private final NonAzureOpenAIClientImpl openAIServiceClient;

    OpenAIClient(OpenAIClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.openAIServiceClient = null;
    }

    OpenAIClient(NonAzureOpenAIClientImpl serviceClient) {
        this.serviceClient = null;
        this.openAIServiceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(String deploymentOrModelName, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptions, requestOptions) : this.serviceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(String deploymentOrModelName, BinaryData completionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions) : this.serviceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions, requestOptions) : this.serviceClient.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Embeddings> getEmbeddingsWithResponse(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = this.getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)embeddingsOptions), requestOptions);
        return new SimpleResponse(response, (Object)((Embeddings)((BinaryData)response.getValue()).toObject(Embeddings.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Completions> getCompletionsWithResponse(String deploymentOrModelName, CompletionsOptions completionsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions);
        return new SimpleResponse(response, (Object)((Completions)((BinaryData)response.getValue()).toObject(Completions.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ChatCompletions> getChatCompletionsWithResponse(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions);
        return new SimpleResponse(response, (Object)((ChatCompletions)((BinaryData)response.getValue()).toObject(ChatCompletions.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Embeddings getEmbeddings(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (Embeddings)((BinaryData)this.getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)embeddingsOptions), requestOptions).getValue()).toObject(Embeddings.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (Completions)((BinaryData)this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).getValue()).toObject(Completions.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, String prompt) {
        return this.getCompletions(deploymentOrModelName, CompletionsUtils.defaultCompletionsOptions(prompt));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<Completions> getCompletionsStream(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        completionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = ((BinaryData)this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<Completions> completionsStream = new OpenAIServerSentEvents<Completions>((Flux<ByteBuffer>)responseStream, Completions.class);
        return new IterableStream(completionsStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ChatCompletions getChatCompletions(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        if (chatCompletionsOptions.getDataSources() == null || chatCompletionsOptions.getDataSources().isEmpty()) {
            return (ChatCompletions)this.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions, requestOptions).getValue();
        }
        return (ChatCompletions)((BinaryData)this.getChatCompletionsWithAzureExtensionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).getValue()).toObject(ChatCompletions.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<ChatCompletions> getChatCompletionsStream(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        chatCompletionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = chatCompletionsOptions.getDataSources() == null || chatCompletionsOptions.getDataSources().isEmpty() ? ((BinaryData)this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).getValue()).toFluxByteBuffer() : ((BinaryData)this.getChatCompletionsWithAzureExtensionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream = new OpenAIServerSentEvents<ChatCompletions>((Flux<ByteBuffer>)responseStream, ChatCompletions.class);
        return new IterableStream(chatCompletionsStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ImageResponse getImages(ImageGenerationOptions imageGenerationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        BinaryData imageGenerationOptionsBinaryData = BinaryData.fromObject((Object)imageGenerationOptions);
        if (this.openAIServiceClient != null) {
            return (ImageResponse)((BinaryData)this.openAIServiceClient.generateImageWithResponse(imageGenerationOptionsBinaryData, requestOptions).getValue()).toObject(ImageResponse.class);
        }
        return ((ImageOperationResponse)((BinaryData)this.beginBeginAzureBatchImageGeneration(imageGenerationOptionsBinaryData, requestOptions).getFinalResult()).toObject(ImageOperationResponse.class)).getResult();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<BinaryData, BinaryData> beginBeginAzureBatchImageGeneration(BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        return this.serviceClient.beginBeginAzureBatchImageGeneration(imageGenerationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getChatCompletionsWithAzureExtensionsWithResponse(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return this.serviceClient.getChatCompletionsWithAzureExtensionsWithResponse(deploymentOrModelName, chatCompletionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AudioTranscription getAudioTranscription(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return (AudioTranscription)this.getAudioTranscriptionWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AudioTranscription> getAudioTranscriptionWithResponse(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        AudioTranscriptionValidator.validateAudioResponseFormatForTranscription(audioTranscriptionOptions);
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        MultipartDataHelper helper = new MultipartDataHelper();
        MultipartDataSerializationResult result = helper.serializeRequest(audioTranscriptionOptions, fileName);
        BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, data, requestOptions) : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, data, requestOptions);
        return new SimpleResponse(response, (Object)((AudioTranscription)((BinaryData)response.getValue()).toObject(AudioTranscription.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getAudioTranscriptionText(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return (String)this.getAudioTranscriptionTextWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getAudioTranscriptionTextWithResponse(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        AudioTranscriptionValidator.validateAudioResponseFormatForTranscriptionText(audioTranscriptionOptions);
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        MultipartDataHelper helper = new MultipartDataHelper();
        MultipartDataSerializationResult result = helper.serializeRequest(audioTranscriptionOptions, fileName);
        BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, data, requestOptions) : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, data, requestOptions);
        return new SimpleResponse(response, (Object)((BinaryData)response.getValue()).toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AudioTranslation getAudioTranslation(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions) {
        return (AudioTranslation)this.getAudioTranslationWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AudioTranslation> getAudioTranslationWithResponse(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        AudioTranslationValidator.validateAudioResponseFormatForTranslation(audioTranslationOptions);
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        MultipartDataHelper helper = new MultipartDataHelper();
        MultipartDataSerializationResult result = helper.serializeRequest(audioTranslationOptions, fileName);
        BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, data, requestOptions) : this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, data, requestOptions);
        return new SimpleResponse(response, (Object)((AudioTranslation)((BinaryData)response.getValue()).toObject(AudioTranslation.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getAudioTranslationText(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions) {
        return (String)this.getAudioTranslationTextWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getAudioTranslationTextWithResponse(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        AudioTranslationValidator.validateAudioResponseFormatForTranslationText(audioTranslationOptions);
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        MultipartDataHelper helper = new MultipartDataHelper();
        MultipartDataSerializationResult result = helper.serializeRequest(audioTranslationOptions, fileName);
        BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, data, requestOptions) : this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, data, requestOptions);
        return new SimpleResponse(response, (Object)((BinaryData)response.getValue()).toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranscriptionAsResponseObjectWithResponse(String deploymentOrModelName, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranscriptionAsResponseObjectWithResponse(deploymentOrModelName, audioTranscriptionOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranscriptionAsPlainTextWithResponse(String deploymentOrModelName, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, audioTranscriptionOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranslationAsResponseObjectWithResponse(String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranslationAsResponseObjectWithResponse(deploymentOrModelName, audioTranslationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranslationAsPlainTextWithResponse(String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, audioTranslationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AudioTranscription getAudioTranscriptionAsResponseObject(String deploymentOrModelName, AudioTranscriptionOptions audioTranscriptionOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (AudioTranscription)((BinaryData)this.getAudioTranscriptionAsResponseObjectWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranscriptionOptions), requestOptions).getValue()).toObject(AudioTranscription.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getAudioTranscriptionAsPlainText(String deploymentOrModelName, AudioTranscriptionOptions audioTranscriptionOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (String)((BinaryData)this.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranscriptionOptions), requestOptions).getValue()).toObject(String.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AudioTranslation getAudioTranslationAsResponseObject(String deploymentOrModelName, AudioTranslationOptions audioTranslationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (AudioTranslation)((BinaryData)this.getAudioTranslationAsResponseObjectWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranslationOptions), requestOptions).getValue()).toObject(AudioTranslation.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getAudioTranslationAsPlainText(String deploymentOrModelName, AudioTranslationOptions audioTranslationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (String)((BinaryData)this.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranslationOptions), requestOptions).getValue()).toObject(String.class);
    }
}

