/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.CompletionsUsage;
import com.azure.ai.openai.models.PromptFilterResult;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;

public final class ChatCompletions {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="choices")
    private List<ChatChoice> choices;
    @JsonProperty(value="usage")
    private CompletionsUsage usage;
    @JsonProperty(value="created")
    private long createdAt;
    @JsonProperty(value="prompt_filter_results")
    private List<PromptFilterResult> promptFilterResults;
    @Deprecated
    @JsonProperty(value="prompt_annotations")
    private List<PromptFilterResult> promptAnnotations;

    public String getId() {
        return this.id;
    }

    public List<ChatChoice> getChoices() {
        return this.choices;
    }

    public CompletionsUsage getUsage() {
        return this.usage;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public List<PromptFilterResult> getPromptFilterResults() {
        if (this.promptFilterResults != null) {
            return this.promptFilterResults;
        }
        return this.promptAnnotations;
    }

    private ChatCompletions(String id, OffsetDateTime createdAt, List<ChatChoice> choices, CompletionsUsage usage) {
        this.id = id;
        this.createdAt = createdAt.toEpochSecond();
        this.choices = choices;
        this.usage = usage;
    }

    @JsonCreator
    private ChatCompletions(@JsonProperty(value="id") String id, @JsonProperty(value="created") long createdAt, @JsonProperty(value="choices") List<ChatChoice> choices, @JsonProperty(value="usage") CompletionsUsage usage) {
        this(id, OffsetDateTime.ofInstant(Instant.ofEpochSecond(createdAt), ZoneOffset.UTC), choices, usage);
    }
}

