/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.Choice;
import com.azure.ai.openai.models.CompletionsUsage;
import com.azure.ai.openai.models.PromptFilterResult;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;

public final class Completions {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="choices")
    private List<Choice> choices;
    @JsonProperty(value="usage")
    private CompletionsUsage usage;
    @JsonProperty(value="prompt_filter_results")
    private List<PromptFilterResult> promptFilterResults;
    @Deprecated
    @JsonProperty(value="prompt_annotations")
    private List<PromptFilterResult> promptAnnotations;
    @JsonProperty(value="created")
    private long createdAt;

    public String getId() {
        return this.id;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public CompletionsUsage getUsage() {
        return this.usage;
    }

    public List<PromptFilterResult> getPromptFilterResults() {
        if (this.promptFilterResults != null) {
            return this.promptFilterResults;
        }
        return this.promptAnnotations;
    }

    private Completions(String id, OffsetDateTime createdAt, List<Choice> choices, CompletionsUsage usage) {
        this.id = id;
        this.createdAt = createdAt.toEpochSecond();
        this.choices = choices;
        this.usage = usage;
    }

    @JsonCreator
    private Completions(@JsonProperty(value="id") String id, @JsonProperty(value="created") long createdAt, @JsonProperty(value="choices") List<Choice> choices, @JsonProperty(value="usage") CompletionsUsage usage) {
        this(id, OffsetDateTime.ofInstant(Instant.ofEpochSecond(createdAt), ZoneOffset.UTC), choices, usage);
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }
}

