// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A specific representation of configurable options for Azure Cognitive Search when using it as an Azure OpenAI chat
 * extension.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("AzureCognitiveSearch")
@Immutable
public final class AzureCognitiveSearchChatExtensionConfiguration extends AzureChatExtensionConfiguration {

    /*
     * The parameters to use when configuring Azure Cognitive Search.
     */
    @Generated
    @JsonProperty(value = "parameters")
    private AzureCognitiveSearchChatExtensionParameters parameters;

    /**
     * Get the parameters property: The parameters to use when configuring Azure Cognitive Search.
     *
     * @return the parameters value.
     */
    @Generated
    public AzureCognitiveSearchChatExtensionParameters getParameters() {
        return this.parameters;
    }

    /**
     * Creates an instance of AzureCognitiveSearchChatExtensionConfiguration class.
     *
     * @param parameters the parameters value to set.
     */
    @Generated
    @JsonCreator
    public AzureCognitiveSearchChatExtensionConfiguration(
        @JsonProperty(value = "parameters") AzureCognitiveSearchChatExtensionParameters parameters) {
        this.parameters = parameters;
    }
}
