// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The type of Azure Cognitive Search retrieval query that should be executed when using it as an Azure OpenAI chat
 * extension.
 */
public final class AzureCognitiveSearchQueryType extends ExpandableStringEnum<AzureCognitiveSearchQueryType> {

    /**
     * Represents the default, simple query parser.
     */
    @Generated
    public static final AzureCognitiveSearchQueryType SIMPLE = fromString("simple");

    /**
     * Represents the semantic query parser for advanced semantic modeling.
     */
    @Generated
    public static final AzureCognitiveSearchQueryType SEMANTIC = fromString("semantic");

    /**
     * Represents vector search over computed data.
     */
    @Generated
    public static final AzureCognitiveSearchQueryType VECTOR = fromString("vector");

    /**
     * Represents a combination of the simple query strategy with vector data.
     */
    @Generated
    public static final AzureCognitiveSearchQueryType VECTOR_SIMPLE_HYBRID = fromString("vectorSimpleHybrid");

    /**
     * Represents a combination of semantic search and vector data querying.
     */
    @Generated
    public static final AzureCognitiveSearchQueryType VECTOR_SEMANTIC_HYBRID = fromString("vectorSemanticHybrid");

    /**
     * Creates a new instance of AzureCognitiveSearchQueryType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public AzureCognitiveSearchQueryType() {
    }

    /**
     * Creates or finds a AzureCognitiveSearchQueryType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AzureCognitiveSearchQueryType.
     */
    @Generated
    @JsonCreator
    public static AzureCognitiveSearchQueryType fromString(String name) {
        return fromString(name, AzureCognitiveSearchQueryType.class);
    }

    /**
     * Gets known AzureCognitiveSearchQueryType values.
     *
     * @return known AzureCognitiveSearchQueryType values.
     */
    @Generated
    public static Collection<AzureCognitiveSearchQueryType> values() {
        return values(AzureCognitiveSearchQueryType.class);
    }
}
