// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters to use when configuring Azure OpenAI On Your Data chat extensions when using Azure Cosmos DB for
 * MongoDB vCore.
 */
@Fluent
public final class AzureCosmosDBChatExtensionParameters {

    /*
     * The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     */
    @Generated
    @JsonProperty(value = "authentication")
    private OnYourDataAuthenticationOptions authentication;

    /*
     * The configured top number of documents to feature for the configured query.
     */
    @Generated
    @JsonProperty(value = "topNDocuments")
    private Integer topNDocuments;

    /*
     * Whether queries should be restricted to use of indexed data.
     */
    @Generated
    @JsonProperty(value = "inScope")
    private Boolean inScope;

    /*
     * The configured strictness of the search relevance filtering. The higher of strictness, the higher of the
     * precision but lower recall of the answer.
     */
    @Generated
    @JsonProperty(value = "strictness")
    private Integer strictness;

    /*
     * Give the model instructions about how it should behave and any context it should reference when generating a
     * response. You can describe the assistant's personality and tell it how to format responses. There's a 100 token
     * limit for it, and it counts against the overall token limit.
     */
    @Generated
    @JsonProperty(value = "roleInformation")
    private String roleInformation;

    /*
     * The MongoDB vCore database name to use with Azure Cosmos DB.
     */
    @Generated
    @JsonProperty(value = "databaseName")
    private String databaseName;

    /*
     * The name of the Azure Cosmos DB resource container.
     */
    @Generated
    @JsonProperty(value = "containerName")
    private String containerName;

    /*
     * The MongoDB vCore index name to use with Azure Cosmos DB.
     */
    @Generated
    @JsonProperty(value = "indexName")
    private String indexName;

    /*
     * Customized field mapping behavior to use when interacting with the search index.
     */
    @Generated
    @JsonProperty(value = "fieldsMapping")
    private AzureCosmosDBFieldMappingOptions fieldsMapping;

    /*
     * The embedding dependency for vector search.
     */
    @Generated
    @JsonProperty(value = "embeddingDependency")
    private OnYourDataVectorizationSource embeddingDependency;

    /**
     * Creates an instance of AzureCosmosDBChatExtensionParameters class.
     *
     * @param databaseName the databaseName value to set.
     * @param containerName the containerName value to set.
     * @param indexName the indexName value to set.
     * @param fieldsMapping the fieldsMapping value to set.
     */
    @Generated
    @JsonCreator
    public AzureCosmosDBChatExtensionParameters(@JsonProperty(value = "databaseName") String databaseName,
        @JsonProperty(value = "containerName") String containerName,
        @JsonProperty(value = "indexName") String indexName,
        @JsonProperty(value = "fieldsMapping") AzureCosmosDBFieldMappingOptions fieldsMapping) {
        this.databaseName = databaseName;
        this.containerName = containerName;
        this.indexName = indexName;
        this.fieldsMapping = fieldsMapping;
    }

    /**
     * Get the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @return the authentication value.
     */
    @Generated
    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    /**
     * Set the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @param authentication the authentication value to set.
     * @return the AzureCosmosDBChatExtensionParameters object itself.
     */
    @Generated
    public AzureCosmosDBChatExtensionParameters setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    /**
     * Get the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @return the topNDocuments value.
     */
    @Generated
    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    /**
     * Set the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @param topNDocuments the topNDocuments value to set.
     * @return the AzureCosmosDBChatExtensionParameters object itself.
     */
    @Generated
    public AzureCosmosDBChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    /**
     * Get the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @return the inScope value.
     */
    @Generated
    public Boolean isInScope() {
        return this.inScope;
    }

    /**
     * Set the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @param inScope the inScope value to set.
     * @return the AzureCosmosDBChatExtensionParameters object itself.
     */
    @Generated
    public AzureCosmosDBChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    /**
     * Get the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @return the strictness value.
     */
    @Generated
    public Integer getStrictness() {
        return this.strictness;
    }

    /**
     * Set the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @param strictness the strictness value to set.
     * @return the AzureCosmosDBChatExtensionParameters object itself.
     */
    @Generated
    public AzureCosmosDBChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    /**
     * Get the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @return the roleInformation value.
     */
    @Generated
    public String getRoleInformation() {
        return this.roleInformation;
    }

    /**
     * Set the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @param roleInformation the roleInformation value to set.
     * @return the AzureCosmosDBChatExtensionParameters object itself.
     */
    @Generated
    public AzureCosmosDBChatExtensionParameters setRoleInformation(String roleInformation) {
        this.roleInformation = roleInformation;
        return this;
    }

    /**
     * Get the databaseName property: The MongoDB vCore database name to use with Azure Cosmos DB.
     *
     * @return the databaseName value.
     */
    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * Get the containerName property: The name of the Azure Cosmos DB resource container.
     *
     * @return the containerName value.
     */
    @Generated
    public String getContainerName() {
        return this.containerName;
    }

    /**
     * Get the indexName property: The MongoDB vCore index name to use with Azure Cosmos DB.
     *
     * @return the indexName value.
     */
    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    /**
     * Get the fieldsMapping property: Customized field mapping behavior to use when interacting with the search index.
     *
     * @return the fieldsMapping value.
     */
    @Generated
    public AzureCosmosDBFieldMappingOptions getFieldsMapping() {
        return this.fieldsMapping;
    }

    /**
     * Get the embeddingDependency property: The embedding dependency for vector search.
     *
     * @return the embeddingDependency value.
     */
    @Generated
    public OnYourDataVectorizationSource getEmbeddingDependency() {
        return this.embeddingDependency;
    }

    /**
     * Set the embeddingDependency property: The embedding dependency for vector search.
     *
     * @param embeddingDependency the embeddingDependency value to set.
     * @return the AzureCosmosDBChatExtensionParameters object itself.
     */
    @Generated
    public AzureCosmosDBChatExtensionParameters
        setEmbeddingDependency(OnYourDataVectorizationSource embeddingDependency) {
        this.embeddingDependency = embeddingDependency;
        return this;
    }
}
