// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Optional settings to control how fields are processed when using a configured Azure Cosmos DB resource.
 */
@Immutable
public final class AzureCosmosDBFieldMappingOptions {

    /*
     * The names of fields that represent vector data.
     */
    @Generated
    @JsonProperty(value = "vectorFields")
    private List<String> vectorFields;

    /**
     * Creates an instance of AzureCosmosDBFieldMappingOptions class.
     *
     * @param vectorFields the vectorFields value to set.
     */
    @Generated
    @JsonCreator
    public AzureCosmosDBFieldMappingOptions(@JsonProperty(value = "vectorFields") List<String> vectorFields) {
        this.vectorFields = vectorFields;
    }

    /**
     * Get the vectorFields property: The names of fields that represent vector data.
     *
     * @return the vectorFields value.
     */
    @Generated
    public List<String> getVectorFields() {
        return this.vectorFields;
    }
}
