// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A content line object consisting of an adjacent sequence of content elements, such as words and selection marks.
 */
@Immutable
public final class AzureGroundingEnhancementLine {

    /*
     * The text within the line.
     */
    @Generated
    @JsonProperty(value = "text")
    private String text;

    /*
     * An array of spans that represent detected objects and its bounding box information.
     */
    @Generated
    @JsonProperty(value = "spans")
    private List<AzureGroundingEnhancementLineSpan> spans;

    /**
     * Creates an instance of AzureGroundingEnhancementLine class.
     *
     * @param text the text value to set.
     * @param spans the spans value to set.
     */
    @Generated
    @JsonCreator
    private AzureGroundingEnhancementLine(@JsonProperty(value = "text") String text,
        @JsonProperty(value = "spans") List<AzureGroundingEnhancementLineSpan> spans) {
        this.text = text;
        this.spans = spans;
    }

    /**
     * Get the text property: The text within the line.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the spans property: An array of spans that represent detected objects and its bounding box information.
     *
     * @return the spans value.
     */
    @Generated
    public List<AzureGroundingEnhancementLineSpan> getSpans() {
        return this.spans;
    }
}
