// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters for the Azure Machine Learning vector index chat extension.
 */
@Fluent
public final class AzureMachineLearningIndexChatExtensionParameters {

    /*
     * The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     */
    @Generated
    @JsonProperty(value = "authentication")
    private OnYourDataAuthenticationOptions authentication;

    /*
     * The configured top number of documents to feature for the configured query.
     */
    @Generated
    @JsonProperty(value = "topNDocuments")
    private Integer topNDocuments;

    /*
     * Whether queries should be restricted to use of indexed data.
     */
    @Generated
    @JsonProperty(value = "inScope")
    private Boolean inScope;

    /*
     * The configured strictness of the search relevance filtering. The higher of strictness, the higher of the
     * precision but lower recall of the answer.
     */
    @Generated
    @JsonProperty(value = "strictness")
    private Integer strictness;

    /*
     * Give the model instructions about how it should behave and any context it should reference when generating a
     * response. You can describe the assistant's personality and tell it how to format responses. There's a 100 token
     * limit for it, and it counts against the overall token limit.
     */
    @Generated
    @JsonProperty(value = "roleInformation")
    private String roleInformation;

    /*
     * The resource ID of the Azure Machine Learning project.
     */
    @Generated
    @JsonProperty(value = "projectResourceId")
    private String projectResourceId;

    /*
     * The Azure Machine Learning vector index name.
     */
    @Generated
    @JsonProperty(value = "name")
    private String name;

    /*
     * The version of the Azure Machine Learning vector index.
     */
    @Generated
    @JsonProperty(value = "version")
    private String version;

    /*
     * Search filter. Only supported if the Azure Machine Learning vector index is of type AzureSearch.
     */
    @Generated
    @JsonProperty(value = "filter")
    private String filter;

    /**
     * Creates an instance of AzureMachineLearningIndexChatExtensionParameters class.
     *
     * @param projectResourceId the projectResourceId value to set.
     * @param name the name value to set.
     * @param version the version value to set.
     */
    @Generated
    @JsonCreator
    public AzureMachineLearningIndexChatExtensionParameters(
        @JsonProperty(value = "projectResourceId") String projectResourceId, @JsonProperty(value = "name") String name,
        @JsonProperty(value = "version") String version) {
        this.projectResourceId = projectResourceId;
        this.name = name;
        this.version = version;
    }

    /**
     * Get the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @return the authentication value.
     */
    @Generated
    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    /**
     * Set the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @param authentication the authentication value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters
        setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    /**
     * Get the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @return the topNDocuments value.
     */
    @Generated
    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    /**
     * Set the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @param topNDocuments the topNDocuments value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    /**
     * Get the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @return the inScope value.
     */
    @Generated
    public Boolean isInScope() {
        return this.inScope;
    }

    /**
     * Set the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @param inScope the inScope value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    /**
     * Get the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @return the strictness value.
     */
    @Generated
    public Integer getStrictness() {
        return this.strictness;
    }

    /**
     * Set the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @param strictness the strictness value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    /**
     * Get the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @return the roleInformation value.
     */
    @Generated
    public String getRoleInformation() {
        return this.roleInformation;
    }

    /**
     * Set the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @param roleInformation the roleInformation value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setRoleInformation(String roleInformation) {
        this.roleInformation = roleInformation;
        return this;
    }

    /**
     * Get the projectResourceId property: The resource ID of the Azure Machine Learning project.
     *
     * @return the projectResourceId value.
     */
    @Generated
    public String getProjectResourceId() {
        return this.projectResourceId;
    }

    /**
     * Get the name property: The Azure Machine Learning vector index name.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the version property: The version of the Azure Machine Learning vector index.
     *
     * @return the version value.
     */
    @Generated
    public String getVersion() {
        return this.version;
    }

    /**
     * Get the filter property: Search filter. Only supported if the Azure Machine Learning vector index is of type
     * AzureSearch.
     *
     * @return the filter value.
     */
    @Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: Search filter. Only supported if the Azure Machine Learning vector index is of type
     * AzureSearch.
     *
     * @param filter the filter value to set.
     * @return the AzureMachineLearningIndexChatExtensionParameters object itself.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters setFilter(String filter) {
        this.filter = filter;
        return this;
    }
}
