// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * An abstract representation of a chat message as provided in a request.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "role",
    defaultImpl = ChatRequestMessage.class)
@JsonTypeName("ChatRequestMessage")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "system", value = ChatRequestSystemMessage.class),
    @JsonSubTypes.Type(name = "user", value = ChatRequestUserMessage.class),
    @JsonSubTypes.Type(name = "assistant", value = ChatRequestAssistantMessage.class),
    @JsonSubTypes.Type(name = "tool", value = ChatRequestToolMessage.class),
    @JsonSubTypes.Type(name = "function", value = ChatRequestFunctionMessage.class) })
@Immutable
public class ChatRequestMessage {

    /**
     * Creates an instance of ChatRequestMessage class.
     */
    @Generated
    public ChatRequestMessage() {
    }
}
