// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * A request chat message representing user input to the assistant.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "role")
@JsonTypeName("user")
@Fluent
public final class ChatRequestUserMessage extends ChatRequestMessage {

    /*
     * The contents of the user message, with available input types varying by selected model.
     */
    @Generated
    @JsonProperty(value = "content")
    private BinaryData content;

    /*
     * An optional name for the participant.
     */
    @Generated
    @JsonProperty(value = "name")
    private String name;

    /**
     * Creates an instance of ChatRequestUserMessage class.
     *
     * @param content the content value to set.
     */
    @JsonCreator
    private ChatRequestUserMessage(@JsonProperty(value = "content") BinaryData content) {
        this.content = content;
    }

    /**
     * Creates a new instance of ChatRequestUserMessage using plain text content.
     *
     * @param content The plain text content associated with the message.
     */
    @JsonCreator
    public ChatRequestUserMessage(String content) {
        this(BinaryData.fromString(content));
    }

    /**
     * Creates a new instance of ChatRequestUserMessage using a collection of structured content.
     *
     * @param content The collection of structured content associated with the message.
     */
    @JsonCreator
    public ChatRequestUserMessage(ChatMessageContentItem[] content) {
        this(BinaryData.fromObject(Arrays.stream(content).map(BinaryData::fromObject).collect(Collectors.toList())));
    }

    /**
     * Creates a new instance of ChatRequestUserMessage using a collection of structured content.
     *
     * @param content The collection of structured content associated with the message.
     */
    @JsonCreator
    public ChatRequestUserMessage(List<ChatMessageContentItem> content) {
        this(BinaryData.fromObject(content.stream().map(BinaryData::fromObject).collect(Collectors.toList())));
    }

    /**
     * Get the content property: The contents of the user message, with available input types varying by selected
     * model.
     *
     * @return the content value.
     */
    private BinaryData getContent() {
        return this.content;
    }

    /**
     * Get the name property: An optional name for the participant.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: An optional name for the participant.
     *
     * @param name the name value to set.
     * @return the ChatRequestUserMessage object itself.
     */
    @Generated
    public ChatRequestUserMessage setName(String name) {
        this.name = name;
        return this;
    }
}
