// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A representation of a chat message as received in a response.
 */
@Immutable
public final class ChatResponseMessage {

    /*
     * The chat role associated with the message.
     */
    @Generated
    @JsonProperty(value = "role")
    private ChatRole role;

    /*
     * The content of the message.
     */
    @Generated
    @JsonProperty(value = "content")
    private String content;

    /*
     * The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat
     * completions request to resolve as configured.
     */
    @Generated
    @JsonProperty(value = "tool_calls")
    private List<ChatCompletionsToolCall> toolCalls;

    /*
     * The function call that must be resolved and have its output appended to subsequent input messages for the chat
     * completions request to resolve as configured.
     */
    @Generated
    @JsonProperty(value = "function_call")
    private FunctionCall functionCall;

    /*
     * If Azure OpenAI chat extensions are configured, this array represents the incremental steps performed by those
     * extensions while processing the chat completions request.
     */
    @Generated
    @JsonProperty(value = "context")
    private AzureChatExtensionsMessageContext context;

    /**
     * Creates an instance of ChatResponseMessage class.
     *
     * @param role the role value to set.
     * @param content the content value to set.
     */
    @Generated
    @JsonCreator
    private ChatResponseMessage(@JsonProperty(value = "role") ChatRole role,
        @JsonProperty(value = "content") String content) {
        this.role = role;
        this.content = content;
    }

    /**
     * Get the role property: The chat role associated with the message.
     *
     * @return the role value.
     */
    @Generated
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: The content of the message.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the toolCalls property: The tool calls that must be resolved and have their outputs appended to subsequent
     * input messages for the chat
     * completions request to resolve as configured.
     *
     * @return the toolCalls value.
     */
    @Generated
    public List<ChatCompletionsToolCall> getToolCalls() {
        return this.toolCalls;
    }

    /**
     * Get the functionCall property: The function call that must be resolved and have its output appended to
     * subsequent input messages for the chat
     * completions request to resolve as configured.
     *
     * @return the functionCall value.
     */
    @Generated
    public FunctionCall getFunctionCall() {
        return this.functionCall;
    }

    /**
     * Get the context property: If Azure OpenAI chat extensions are configured, this array represents the incremental
     * steps performed by those
     * extensions while processing the chat completions request.
     *
     * @return the context value.
     */
    @Generated
    public AzureChatExtensionsMessageContext getContext() {
        return this.context;
    }
}
