// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The representation of a single prompt completion as part of an overall completions request.
 * Generally, `n` choices are generated per provided prompt with a default value of 1.
 * Token limits and other settings may limit the number of choices generated.
 */
@Immutable
public final class Choice {

    /*
     * The generated text for a given completions prompt.
     */
    @Generated
    @JsonProperty(value = "text")
    private String text;

    /*
     * The ordered index associated with this completions choice.
     */
    @Generated
    @JsonProperty(value = "index")
    private int index;

    /*
     * The log probabilities model for tokens associated with this completions choice.
     */
    @Generated
    @JsonProperty(value = "logprobs")
    private CompletionsLogProbabilityModel logprobs;

    /*
     * Reason for finishing
     */
    @Generated
    @JsonProperty(value = "finish_reason")
    private CompletionsFinishReason finishReason;

    /**
     * Creates an instance of Choice class.
     *
     * @param text the text value to set.
     * @param index the index value to set.
     * @param logprobs the logprobs value to set.
     * @param finishReason the finishReason value to set.
     */
    @Generated
    @JsonCreator
    private Choice(@JsonProperty(value = "text") String text, @JsonProperty(value = "index") int index,
        @JsonProperty(value = "logprobs") CompletionsLogProbabilityModel logprobs,
        @JsonProperty(value = "finish_reason") CompletionsFinishReason finishReason) {
        this.text = text;
        this.index = index;
        this.logprobs = logprobs;
        this.finishReason = finishReason;
    }

    /**
     * Get the text property: The generated text for a given completions prompt.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the index property: The ordered index associated with this completions choice.
     *
     * @return the index value.
     */
    @Generated
    public int getIndex() {
        return this.index;
    }

    /**
     * Get the logprobs property: The log probabilities model for tokens associated with this completions choice.
     *
     * @return the logprobs value.
     */
    @Generated
    public CompletionsLogProbabilityModel getLogprobs() {
        return this.logprobs;
    }

    /**
     * Get the finishReason property: Reason for finishing.
     *
     * @return the finishReason value.
     */
    @Generated
    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }

    /*
     * Information about the content filtering category (hate, sexual, violence, self_harm), if it
     * has been detected, as well as the severity level (very_low, low, medium, high-scale that
     * determines the intensity and risk level of harmful content) and if it has been filtered or not.
     */
    @Generated
    @JsonProperty(value = "content_filter_results")
    private ContentFilterResultsForChoice contentFilterResults;

    /**
     * Get the contentFilterResults property: Information about the content filtering category (hate, sexual, violence,
     * self_harm), if it
     * has been detected, as well as the severity level (very_low, low, medium, high-scale that
     * determines the intensity and risk level of harmful content) and if it has been filtered or not.
     *
     * @return the contentFilterResults value.
     */
    @Generated
    public ContentFilterResultsForChoice getContentFilterResults() {
        return this.contentFilterResults;
    }
}
