// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents the outcome of an evaluation against a custom blocklist as performed by content filtering.
 */
@Immutable
public final class ContentFilterBlocklistIdResult {

    /*
     * The ID of the custom blocklist evaluated.
     */
    @Generated
    @JsonProperty(value = "id")
    private String id;

    /*
     * A value indicating whether or not the content has been filtered.
     */
    @Generated
    @JsonProperty(value = "filtered")
    private boolean filtered;

    /**
     * Creates an instance of ContentFilterBlocklistIdResult class.
     *
     * @param id the id value to set.
     * @param filtered the filtered value to set.
     */
    @Generated
    @JsonCreator
    private ContentFilterBlocklistIdResult(@JsonProperty(value = "id") String id,
        @JsonProperty(value = "filtered") boolean filtered) {
        this.id = id;
        this.filtered = filtered;
    }

    /**
     * Get the id property: The ID of the custom blocklist evaluated.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the filtered property: A value indicating whether or not the content has been filtered.
     *
     * @return the filtered value.
     */
    @Generated
    public boolean isFiltered() {
        return this.filtered;
    }
}
