// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai;

import static com.azure.ai.openai.implementation.AudioTranscriptionValidator.validateAudioResponseFormatForTranscription;
import static com.azure.ai.openai.implementation.AudioTranscriptionValidator.validateAudioResponseFormatForTranscriptionText;
import static com.azure.ai.openai.implementation.AudioTranslationValidator.validateAudioResponseFormatForTranslation;
import static com.azure.ai.openai.implementation.AudioTranslationValidator.validateAudioResponseFormatForTranslationText;
import static com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl.addModelIdJson;

import com.azure.ai.openai.implementation.CompletionsUtils;
import com.azure.ai.openai.implementation.MultipartDataHelper;
import com.azure.ai.openai.implementation.MultipartDataSerializationResult;
import com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.models.AudioTranscription;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.azure.ai.openai.models.AudioTranslation;
import com.azure.ai.openai.models.AudioTranslationOptions;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.ai.openai.models.ImageGenerationOptions;
import com.azure.ai.openai.models.ImageGenerations;
import com.azure.ai.openai.models.SpeechGenerationOptions;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

/**
 * Initializes a new instance of the synchronous OpenAIClient type.
 */
@ServiceClient(builder = OpenAIClientBuilder.class)
public final class OpenAIClient {

    private static final ClientLogger LOGGER = new ClientLogger(OpenAIClient.class);

    @Generated
    private final OpenAIClientImpl serviceClient;

    private final NonAzureOpenAIClientImpl openAIServiceClient;

    /**
     * Initializes an instance of OpenAIClient class.
     *
     * @param serviceClient the service client implementation.
     */
    OpenAIClient(OpenAIClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        openAIServiceClient = null;
    }

    /**
     * Initializes an instance of OpenAIClient class for NonAzure Implementation.
     *
     * @param serviceClient the service client implementation.
     */
    OpenAIClient(NonAzureOpenAIClientImpl serviceClient) {
        this.serviceClient = null;
        openAIServiceClient = serviceClient;
    }

    /**
     * Return the embeddings for a given prompt.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     user: String (Optional)
     *     model: String (Optional)
     *     input (Required): [
     *         String (Required)
     *     ]
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     data (Required): [
     *          (Required){
     *             embedding (Required): [
     *                 double (Required)
     *             ]
     *             index: int (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param embeddingsOptions The configuration information for an embeddings request. Embeddings measure the
     * relatedness of text strings and are commonly used for search, clustering, recommendations, and other similar
     * scenarios.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return representation of the response data from an embeddings request. Embeddings measure the relatedness of
     * text strings and are commonly used for search, clustering, recommendations, and other similar scenarios along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(String deploymentOrModelName, BinaryData embeddingsOptions,
        RequestOptions requestOptions) {
        return openAIServiceClient != null
            ? openAIServiceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptions, requestOptions)
            : serviceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptions, requestOptions);
    }

    /**
     * Gets completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     prompt (Required): [
     *         String (Required)
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     logprobs: Integer (Optional)
     *     echo: Boolean (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     best_of: Integer (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             text: String (Required)
     *             index: int (Required)
     *             logprobs (Required): {
     *                 tokens (Required): [
     *                     String (Required)
     *                 ]
     *                 token_logprobs (Required): [
     *                     double (Required)
     *                 ]
     *                 top_logprobs (Required): [
     *                      (Required){
     *                         String: double (Required)
     *                     }
     *                 ]
     *                 text_offset (Required): [
     *                     int (Required)
     *                 ]
     *             }
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request. Completions support a wide
     * variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(String deploymentOrModelName, BinaryData completionsOptions,
        RequestOptions requestOptions) {
        return openAIServiceClient != null
            ? openAIServiceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions)
            : serviceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions);
    }

    /**
     * Gets chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     messages (Required): [
     *          (Required){
     *             role: String(system/assistant/user) (Required)
     *             content: String (Optional)
     *         }
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             message (Optional): {
     *                 role: String(system/assistant/user) (Required)
     *                 content: String (Optional)
     *             }
     *             index: int (Required)
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *             delta (Optional): {
     *                 role: String(system/assistant/user) (Optional)
     *                 content: String (Optional)
     *             }
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     * wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(String deploymentOrModelName,
        BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return openAIServiceClient != null
            ? openAIServiceClient.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions,
                requestOptions)
            : serviceClient.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions,
                requestOptions);
    }

    /**
     * Return the embeddings for a given prompt.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     user: String (Optional)
     *     model: String (Optional)
     *     input (Required): [
     *         String (Required)
     *     ]
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     data (Required): [
     *          (Required){
     *             embedding (Required): [
     *                 double (Required)
     *             ]
     *             index: int (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param embeddingsOptions The configuration information for an embeddings request. Embeddings measure the
     * relatedness of text strings and are commonly used for search, clustering, recommendations, and other similar
     * scenarios.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return representation of the response data from an embeddings request. Embeddings measure the relatedness of
     * text strings and are commonly used for search, clustering, recommendations, and other similar scenarios along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Embeddings> getEmbeddingsWithResponse(String deploymentOrModelName,
        EmbeddingsOptions embeddingsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = getEmbeddingsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(embeddingsOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(Embeddings.class));
    }

    /**
     * Gets completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     prompt (Required): [
     *         String (Required)
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     logprobs: Integer (Optional)
     *     echo: Boolean (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     best_of: Integer (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             text: String (Required)
     *             index: int (Required)
     *             logprobs (Required): {
     *                 tokens (Required): [
     *                     String (Required)
     *                 ]
     *                 token_logprobs (Required): [
     *                     double (Required)
     *                 ]
     *                 top_logprobs (Required): [
     *                      (Required){
     *                         String: double (Required)
     *                     }
     *                 ]
     *                 text_offset (Required): [
     *                     int (Required)
     *                 ]
     *             }
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request. Completions support a wide
     * variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Completions> getCompletionsWithResponse(String deploymentOrModelName,
        CompletionsOptions completionsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = getCompletionsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(completionsOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(Completions.class));
    }

    /**
     * Gets chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     messages (Required): [
     *          (Required){
     *             role: String(system/assistant/user) (Required)
     *             content: String (Optional)
     *         }
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             message (Optional): {
     *                 role: String(system/assistant/user) (Required)
     *                 content: String (Optional)
     *             }
     *             index: int (Required)
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *             delta (Optional): {
     *                 role: String(system/assistant/user) (Optional)
     *                 content: String (Optional)
     *             }
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     * wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ChatCompletions> getChatCompletionsWithResponse(String deploymentOrModelName,
        ChatCompletionsOptions chatCompletionsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = getChatCompletionsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(chatCompletionsOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(ChatCompletions.class));
    }

    /**
     * Return the embeddings for a given prompt.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param embeddingsOptions The configuration information for an embeddings request.
     * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
     * recommendations, and other similar scenarios.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return representation of the response data from an embeddings request.
     * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
     * recommendations, and other similar scenarios.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Embeddings getEmbeddings(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions) {
        // Generated convenience method for getEmbeddingsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject(embeddingsOptions),
            requestOptions).getValue().toObject(Embeddings.class);
    }

    /**
     * Gets completions for the provided input prompts.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return completions for the provided input prompts.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        // Generated convenience method for getCompletionsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject(completionsOptions),
            requestOptions).getValue().toObject(Completions.class);
    }

    /**
     * Gets completions for the provided input prompt. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param prompt The prompt to generate completion text from.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, String prompt) {
        return getCompletions(deploymentOrModelName, CompletionsUtils.defaultCompletionsOptions(prompt));
    }

    /**
     * Gets completions as a stream for the provided input prompts. Completions support a wide variety of tasks and
     * generate text that continues from or "completes" provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request. Completions support a wide
     * variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an {@link IterableStream} of completions for the provided input prompts. Completions support a wide
     * variety of tasks and generate text that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public IterableStream<Completions> getCompletionsStream(String deploymentOrModelName,
        CompletionsOptions completionsOptions) {
        completionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux<ByteBuffer> responseStream = getCompletionsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(completionsOptions), requestOptions).getValue().toFluxByteBuffer();
        OpenAIServerSentEvents<Completions> completionsStream
            = new OpenAIServerSentEvents<>(responseStream, Completions.class);
        return new IterableStream<>(completionsStream.getEvents());
    }

    /**
     * Gets chat completions for the provided chat messages.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return chat completions for the provided chat messages.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ChatCompletions getChatCompletions(String deploymentOrModelName,
        ChatCompletionsOptions chatCompletionsOptions) {
        // Generated convenience method for getChatCompletionsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject(chatCompletionsOptions),
            requestOptions).getValue().toObject(ChatCompletions.class);
    }

    /**
     * Gets chat completions for the provided chat messages. Chat completions support a wide variety of tasks and
     * generate text that continues from or "completes" provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     * wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return chat completions stream for the provided chat messages. Completions support a wide variety of tasks and
     * generate text that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public IterableStream<ChatCompletions> getChatCompletionsStream(String deploymentOrModelName,
        ChatCompletionsOptions chatCompletionsOptions) {
        chatCompletionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux<ByteBuffer> responseStream = getChatCompletionsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(chatCompletionsOptions), requestOptions).getValue().toFluxByteBuffer();
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream
            = new OpenAIServerSentEvents<>(responseStream, ChatCompletions.class);
        return new IterableStream<>(chatCompletionsStream.getEvents());
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranscription} transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AudioTranscription getAudioTranscription(String deploymentOrModelName, String fileName,
        AudioTranscriptionOptions audioTranscriptionOptions) {
        return getAudioTranscriptionWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null)
            .getValue();
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranscription} transcribed text and associated metadata from provided spoken audio data along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AudioTranscription> getAudioTranscriptionWithResponse(String deploymentOrModelName, String fileName,
        AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        // checking allowed formats for a JSON response
        validateAudioResponseFormatForTranscription(audioTranscriptionOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        // setting the name as part of the request object will allow users for better visualization in the web dashboard
        if (CoreUtils.isNullOrEmpty(audioTranscriptionOptions.getFilename())) {
            audioTranscriptionOptions.setFilename(fileName);
        }
        final MultipartDataHelper helper = new MultipartDataHelper();
        final MultipartDataSerializationResult result = helper.serializeRequest(audioTranscriptionOptions);
        final BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response = openAIServiceClient != null
            ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, data,
                requestOptions)
            : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, data,
                requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(AudioTranscription.class));
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranscriptionText(String deploymentOrModelName, String fileName,
        AudioTranscriptionOptions audioTranscriptionOptions) {
        return getAudioTranscriptionTextWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null)
            .getValue();
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<String> getAudioTranscriptionTextWithResponse(String deploymentOrModelName, String fileName,
        AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        // checking allowed formats for a plain text response
        validateAudioResponseFormatForTranscriptionText(audioTranscriptionOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        // setting the name as part of the request object will allow users for better visualization in the web dashboard
        if (CoreUtils.isNullOrEmpty(audioTranscriptionOptions.getFilename())) {
            audioTranscriptionOptions.setFilename(fileName);
        }
        final MultipartDataHelper helper = new MultipartDataHelper();
        final MultipartDataSerializationResult result = helper.serializeRequest(audioTranscriptionOptions);
        final BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response = openAIServiceClient != null
            ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, data,
                requestOptions)
            : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, data,
                requestOptions);
        return new SimpleResponse<>(response, response.getValue().toString());
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranscription} english language transcribed text and associated metadata from provided spoken
     * audio file data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AudioTranslation getAudioTranslation(String deploymentOrModelName, String fileName,
        AudioTranslationOptions audioTranslationOptions) {
        return getAudioTranslationWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null)
            .getValue();
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranslation} english language transcribed text and associated metadata from provided spoken
     * audio file data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AudioTranslation> getAudioTranslationWithResponse(String deploymentOrModelName, String fileName,
        AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        // checking allowed formats for a JSON response
        validateAudioResponseFormatForTranslation(audioTranslationOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        // setting the name as part of the request object will allow users for better visualization in the web dashboard
        if (CoreUtils.isNullOrEmpty(audioTranslationOptions.getFilename())) {
            audioTranslationOptions.setFilename(fileName);
        }
        final MultipartDataHelper helper = new MultipartDataHelper();
        final MultipartDataSerializationResult result = helper.serializeRequest(audioTranslationOptions);
        final BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response = openAIServiceClient != null
            ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, data,
                requestOptions)
            : this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, data,
                requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(AudioTranslation.class));
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio file data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranslationText(String deploymentOrModelName, String fileName,
        AudioTranslationOptions audioTranslationOptions) {
        return getAudioTranslationTextWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null)
            .getValue();
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio file data along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<String> getAudioTranslationTextWithResponse(String deploymentOrModelName, String fileName,
        AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        // checking allowed formats for a plain text response
        validateAudioResponseFormatForTranslationText(audioTranslationOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        // setting the name as part of the request object will allow users for better visualization in the web dashboard
        if (CoreUtils.isNullOrEmpty(audioTranslationOptions.getFilename())) {
            audioTranslationOptions.setFilename(fileName);
        }
        final MultipartDataHelper helper = new MultipartDataHelper();
        final MultipartDataSerializationResult result = helper.serializeRequest(audioTranslationOptions);
        final BinaryData data = result.getData();
        requestOptions = helper.getRequestOptionsForMultipartFormData(requestOptions, result, helper.getBoundary());
        Response<BinaryData> response = openAIServiceClient != null
            ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, data,
                requestOptions)
            : this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, data,
                requestOptions);
        return new SimpleResponse<>(response, response.getValue().toString());
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     * <p>
     * <strong>Response Body Schema</strong>
     * </p>
     * <pre>{@code
     * {
     *     text: String (Required)
     *     task: String(transcribe/translate) (Optional)
     *     language: String (Optional)
     *     duration: Double (Optional)
     *     segments (Optional): [
     *          (Optional){
     *             id: int (Required)
     *             start: double (Required)
     *             end: double (Required)
     *             text: String (Required)
     *             temperature: double (Required)
     *             avg_logprob: double (Required)
     *             compression_ratio: double (Required)
     *             no_speech_prob: double (Required)
     *             tokens (Required): [
     *                 int (Required)
     *             ]
     *             seek: int (Required)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return transcribed text and associated metadata from provided spoken audio data along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getAudioTranscriptionAsResponseObjectWithResponse(String deploymentOrModelName,
        BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        // Protocol API requires serialization of parts with content-disposition and data, as operation
        // 'getAudioTranscriptionAsResponseObject' is 'multipart/form-data'
        return this.serviceClient.getAudioTranscriptionAsResponseObjectWithResponse(deploymentOrModelName,
            audioTranscriptionOptions, requestOptions);
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     * <p>
     * <strong>Response Body Schema</strong>
     * </p>
     * <pre>{@code
     * String
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return transcribed text and associated metadata from provided spoken audio data along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getAudioTranscriptionAsPlainTextWithResponse(String deploymentOrModelName,
        BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        // Protocol API requires serialization of parts with content-disposition and data, as operation
        // 'getAudioTranscriptionAsPlainText' is 'multipart/form-data'
        return this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName,
            audioTranscriptionOptions, requestOptions);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     * <p>
     * <strong>Response Body Schema</strong>
     * </p>
     * <pre>{@code
     * {
     *     text: String (Required)
     *     task: String(transcribe/translate) (Optional)
     *     language: String (Optional)
     *     duration: Double (Optional)
     *     segments (Optional): [
     *          (Optional){
     *             id: int (Required)
     *             start: double (Required)
     *             end: double (Required)
     *             text: String (Required)
     *             temperature: double (Required)
     *             avg_logprob: double (Required)
     *             compression_ratio: double (Required)
     *             no_speech_prob: double (Required)
     *             tokens (Required): [
     *                 int (Required)
     *             ]
     *             seek: int (Required)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return english language transcribed text and associated metadata from provided spoken audio data along with
     * {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getAudioTranslationAsResponseObjectWithResponse(String deploymentOrModelName,
        BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        // Protocol API requires serialization of parts with content-disposition and data, as operation
        // 'getAudioTranslationAsResponseObject' is 'multipart/form-data'
        return this.serviceClient.getAudioTranslationAsResponseObjectWithResponse(deploymentOrModelName,
            audioTranslationOptions, requestOptions);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     * <p>
     * <strong>Response Body Schema</strong>
     * </p>
     * <pre>{@code
     * String
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return english language transcribed text and associated metadata from provided spoken audio data along with
     * {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getAudioTranslationAsPlainTextWithResponse(String deploymentOrModelName,
        BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        // Protocol API requires serialization of parts with content-disposition and data, as operation
        // 'getAudioTranslationAsPlainText' is 'multipart/form-data'
        return this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName,
            audioTranslationOptions, requestOptions);
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranscriptionAsPlainText(String deploymentOrModelName,
        AudioTranscriptionOptions audioTranscriptionOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName,
            BinaryData.fromObject(audioTranscriptionOptions), requestOptions).getValue().toObject(String.class);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranslationAsPlainText(String deploymentOrModelName,
        AudioTranslationOptions audioTranslationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName,
            BinaryData.fromObject(audioTranslationOptions), requestOptions).getValue().toObject(String.class);
    }

    /**
     * Creates an image given a prompt.
     * <p>
     * <strong>Request Body Schema</strong>
     * </p>
     * <pre>{@code
     * {
     *     model: String (Optional)
     *     prompt: String (Required)
     *     n: Integer (Optional)
     *     size: String(256x256/512x512/1024x1024/1792x1024/1024x1792) (Optional)
     *     response_format: String(url/b64_json) (Optional)
     *     quality: String(standard/hd) (Optional)
     *     style: String(natural/vivid) (Optional)
     *     user: String (Optional)
     * }
     * }</pre>
     * <p>
     * <strong>Response Body Schema</strong>
     * </p>
     * <pre>{@code
     * {
     *     created: long (Required)
     *     data (Required): [
     *          (Required){
     *             url: String (Optional)
     *             b64_json: String (Optional)
     *             revised_prompt: String (Optional)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param imageGenerationOptions Represents the request data used to generate images.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the result of a successful image generation operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getImageGenerationsWithResponse(String deploymentOrModelName,
        BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        return openAIServiceClient != null
            ? this.openAIServiceClient.getImageGenerationsWithResponse(deploymentOrModelName, imageGenerationOptions,
                requestOptions)
            : this.serviceClient.getImageGenerationsWithResponse(deploymentOrModelName, imageGenerationOptions,
                requestOptions);
    }

    /**
     * Creates an image given a prompt.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param imageGenerationOptions Represents the request data used to generate images.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the result of a successful image generation operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ImageGenerations> getImageGenerationsWithResponse(String deploymentOrModelName,
        ImageGenerationOptions imageGenerationOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = getImageGenerationsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(imageGenerationOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(ImageGenerations.class));
    }

    /**
     * Creates an image given a prompt.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param imageGenerationOptions Represents the request data used to generate images.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a successful image generation operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ImageGenerations getImageGenerations(String deploymentOrModelName,
        ImageGenerationOptions imageGenerationOptions) {
        // Generated convenience method for getImageGenerationsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getImageGenerationsWithResponse(deploymentOrModelName, BinaryData.fromObject(imageGenerationOptions),
            requestOptions).getValue().toObject(ImageGenerations.class);
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AudioTranscription getAudioTranscriptionAsResponseObject(String deploymentOrModelName,
        AudioTranscriptionOptions audioTranscriptionOptions) {
        return getAudioTranscription(deploymentOrModelName, "filename", audioTranscriptionOptions);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AudioTranslation getAudioTranslationAsResponseObject(String deploymentOrModelName,
        AudioTranslationOptions audioTranslationOptions) {
        return getAudioTranslation(deploymentOrModelName, "filename", audioTranslationOptions);
    }

    /**
     * Generates text-to-speech audio from the input text.
     * <p>
     * <strong>Request Body Schema</strong>
     * </p>
     * <pre>{@code
     * {
     *     input: String (Required)
     *     voice: String(alloy/echo/fable/onyx/nova/shimmer) (Required)
     *     response_format: String(mp3/opus/aac/flac) (Optional)
     *     speed: Double (Optional)
     * }
     * }</pre>
     * <p>
     * <strong>Response Body Schema</strong>
     * </p>
     * <pre>{@code
     * BinaryData
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param speechGenerationOptions A representation of the request options that control the behavior of a
     * text-to-speech operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> generateSpeechFromTextWithResponse(String deploymentOrModelName,
        BinaryData speechGenerationOptions, RequestOptions requestOptions) {
        BinaryData speechGenerationOptionsWithModelId = null;
        try {
            speechGenerationOptionsWithModelId = addModelIdJson(speechGenerationOptions, deploymentOrModelName);
        } catch (JsonProcessingException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        return openAIServiceClient != null
            ? this.openAIServiceClient.generateSpeechFromTextWithResponse(speechGenerationOptionsWithModelId,
                requestOptions)
            : this.serviceClient.generateSpeechFromTextWithResponse(deploymentOrModelName,
                speechGenerationOptionsWithModelId, requestOptions);
    }

    /**
     * Generates text-to-speech audio from the input text.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param speechGenerationOptions A representation of the request options that control the behavior of a
     * text-to-speech operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BinaryData generateSpeechFromText(String deploymentOrModelName,
        SpeechGenerationOptions speechGenerationOptions) {
        // Generated convenience method for generateSpeechFromTextWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return generateSpeechFromTextWithResponse(deploymentOrModelName, BinaryData.fromObject(speechGenerationOptions),
            requestOptions).getValue();
    }
}
