// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;

/**
 * Extended information about a single segment of translated audio data.
 * Segments generally represent roughly 5-10 seconds of speech. Segment boundaries typically occur between words but
 * not
 * necessarily sentences.
 */
@Immutable
public final class AudioTranslationSegment {

    /*
     * The 0-based index of this segment within a translation.
     */
    @Generated
    @JsonProperty(value = "id")
    private int id;

    /*
     * The time at which this segment started relative to the beginning of the translated audio.
     */
    @Generated
    @JsonProperty(value = "start")
    private double start;

    /*
     * The time at which this segment ended relative to the beginning of the translated audio.
     */
    @Generated
    @JsonProperty(value = "end")
    private double end;

    /*
     * The translated text that was part of this audio segment.
     */
    @Generated
    @JsonProperty(value = "text")
    private String text;

    /*
     * The temperature score associated with this audio segment.
     */
    @Generated
    @JsonProperty(value = "temperature")
    private double temperature;

    /*
     * The average log probability associated with this audio segment.
     */
    @Generated
    @JsonProperty(value = "avg_logprob")
    private double avgLogprob;

    /*
     * The compression ratio of this audio segment.
     */
    @Generated
    @JsonProperty(value = "compression_ratio")
    private double compressionRatio;

    /*
     * The probability of no speech detection within this audio segment.
     */
    @Generated
    @JsonProperty(value = "no_speech_prob")
    private double noSpeechProb;

    /*
     * The token IDs matching the translated text in this audio segment.
     */
    @Generated
    @JsonProperty(value = "tokens")
    private List<Integer> tokens;

    /*
     * The seek position associated with the processing of this audio segment.
     * Seek positions are expressed as hundredths of seconds.
     * The model may process several segments from a single seek position, so while the seek position will never
     * represent
     * a later time than the segment's start, the segment's start may represent a significantly later time than the
     * segment's associated seek position.
     */
    @Generated
    @JsonProperty(value = "seek")
    private int seek;

    /**
     * Creates an instance of AudioTranslationSegment class.
     *
     * @param id the id value to set.
     * @param start the start value to set.
     * @param end the end value to set.
     * @param text the text value to set.
     * @param temperature the temperature value to set.
     * @param avgLogprob the avgLogprob value to set.
     * @param compressionRatio the compressionRatio value to set.
     * @param noSpeechProb the noSpeechProb value to set.
     * @param tokens the tokens value to set.
     * @param seek the seek value to set.
     */
    @Generated
    private AudioTranslationSegment(int id, Duration start, Duration end, String text, double temperature,
        double avgLogprob, double compressionRatio, double noSpeechProb, List<Integer> tokens, int seek) {
        this.id = id;
        this.start = (double) start.toNanos() / 1000_000_000L;
        this.end = (double) end.toNanos() / 1000_000_000L;
        this.text = text;
        this.temperature = temperature;
        this.avgLogprob = avgLogprob;
        this.compressionRatio = compressionRatio;
        this.noSpeechProb = noSpeechProb;
        this.tokens = tokens;
        this.seek = seek;
    }

    @Generated
    @JsonCreator
    private AudioTranslationSegment(@JsonProperty(value = "id") int id, @JsonProperty(value = "start") double start,
        @JsonProperty(value = "end") double end, @JsonProperty(value = "text") String text,
        @JsonProperty(value = "temperature") double temperature, @JsonProperty(value = "avg_logprob") double avgLogprob,
        @JsonProperty(value = "compression_ratio") double compressionRatio,
        @JsonProperty(value = "no_speech_prob") double noSpeechProb,
        @JsonProperty(value = "tokens") List<Integer> tokens, @JsonProperty(value = "seek") int seek) {
        this(id, Duration.ofNanos((long) (start * 1000_000_000L)), Duration.ofNanos((long) (end * 1000_000_000L)), text,
            temperature, avgLogprob, compressionRatio, noSpeechProb, tokens, seek);
    }

    /**
     * Get the id property: The 0-based index of this segment within a translation.
     *
     * @return the id value.
     */
    @Generated
    public int getId() {
        return this.id;
    }

    /**
     * Get the start property: The time at which this segment started relative to the beginning of the translated
     * audio.
     *
     * @return the start value.
     */
    @Generated
    public Duration getStart() {
        return Duration.ofNanos((long) (this.start * 1000_000_000L));
    }

    /**
     * Get the end property: The time at which this segment ended relative to the beginning of the translated audio.
     *
     * @return the end value.
     */
    @Generated
    public Duration getEnd() {
        return Duration.ofNanos((long) (this.end * 1000_000_000L));
    }

    /**
     * Get the text property: The translated text that was part of this audio segment.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the temperature property: The temperature score associated with this audio segment.
     *
     * @return the temperature value.
     */
    @Generated
    public double getTemperature() {
        return this.temperature;
    }

    /**
     * Get the avgLogprob property: The average log probability associated with this audio segment.
     *
     * @return the avgLogprob value.
     */
    @Generated
    public double getAvgLogprob() {
        return this.avgLogprob;
    }

    /**
     * Get the compressionRatio property: The compression ratio of this audio segment.
     *
     * @return the compressionRatio value.
     */
    @Generated
    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    /**
     * Get the noSpeechProb property: The probability of no speech detection within this audio segment.
     *
     * @return the noSpeechProb value.
     */
    @Generated
    public double getNoSpeechProb() {
        return this.noSpeechProb;
    }

    /**
     * Get the tokens property: The token IDs matching the translated text in this audio segment.
     *
     * @return the tokens value.
     */
    @Generated
    public List<Integer> getTokens() {
        return this.tokens;
    }

    /**
     * Get the seek property: The seek position associated with the processing of this audio segment.
     * Seek positions are expressed as hundredths of seconds.
     * The model may process several segments from a single seek position, so while the seek position will never
     * represent
     * a later time than the segment's start, the segment's start may represent a significantly later time than the
     * segment's associated seek position.
     *
     * @return the seek value.
     */
    @Generated
    public int getSeek() {
        return this.seek;
    }
}
