// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The type of Azure Search retrieval query that should be executed when using it as an Azure OpenAI chat extension.
 */
public final class AzureSearchQueryType extends ExpandableStringEnum<AzureSearchQueryType> {

    /**
     * Represents the default, simple query parser.
     */
    @Generated
    public static final AzureSearchQueryType SIMPLE = fromString("simple");

    /**
     * Represents the semantic query parser for advanced semantic modeling.
     */
    @Generated
    public static final AzureSearchQueryType SEMANTIC = fromString("semantic");

    /**
     * Represents vector search over computed data.
     */
    @Generated
    public static final AzureSearchQueryType VECTOR = fromString("vector");

    /**
     * Represents a combination of the simple query strategy with vector data.
     */
    @Generated
    public static final AzureSearchQueryType VECTOR_SIMPLE_HYBRID = fromString("vector_simple_hybrid");

    /**
     * Represents a combination of semantic search and vector data querying.
     */
    @Generated
    public static final AzureSearchQueryType VECTOR_SEMANTIC_HYBRID = fromString("vector_semantic_hybrid");

    /**
     * Creates a new instance of AzureSearchQueryType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public AzureSearchQueryType() {
    }

    /**
     * Creates or finds a AzureSearchQueryType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AzureSearchQueryType.
     */
    @Generated
    @JsonCreator
    public static AzureSearchQueryType fromString(String name) {
        return fromString(name, AzureSearchQueryType.class);
    }

    /**
     * Gets known AzureSearchQueryType values.
     *
     * @return known AzureSearchQueryType values.
     */
    @Generated
    public static Collection<AzureSearchQueryType> values() {
        return values(AzureSearchQueryType.class);
    }
}
