// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters for configuring Azure OpenAI Pinecone chat extensions. The supported authentication type is APIKey.
 */
@Fluent
public final class PineconeChatExtensionParameters {

    /*
     * The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     */
    @Generated
    @JsonProperty(value = "authentication")
    private OnYourDataAuthenticationOptions authentication;

    /*
     * The configured top number of documents to feature for the configured query.
     */
    @Generated
    @JsonProperty(value = "top_n_documents")
    private Integer topNDocuments;

    /*
     * Whether queries should be restricted to use of indexed data.
     */
    @Generated
    @JsonProperty(value = "in_scope")
    private Boolean inScope;

    /*
     * The configured strictness of the search relevance filtering. The higher of strictness, the higher of the
     * precision but lower recall of the answer.
     */
    @Generated
    @JsonProperty(value = "strictness")
    private Integer strictness;

    /*
     * Give the model instructions about how it should behave and any context it should reference when generating a
     * response. You can describe the assistant's personality and tell it how to format responses. There's a 100 token
     * limit for it, and it counts against the overall token limit.
     */
    @Generated
    @JsonProperty(value = "role_information")
    private String roleInformation;

    /*
     * The environment name of Pinecone.
     */
    @Generated
    @JsonProperty(value = "environment")
    private String environment;

    /*
     * The name of the Pinecone database index.
     */
    @Generated
    @JsonProperty(value = "index_name")
    private String indexName;

    /*
     * Customized field mapping behavior to use when interacting with the search index.
     */
    @Generated
    @JsonProperty(value = "fields_mapping")
    private PineconeFieldMappingOptions fieldsMapping;

    /*
     * The embedding dependency for vector search.
     */
    @Generated
    @JsonProperty(value = "embedding_dependency")
    private OnYourDataVectorizationSource embeddingDependency;

    /**
     * Get the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @return the authentication value.
     */
    @Generated
    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    /**
     * Set the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @param authentication the authentication value to set.
     * @return the PineconeChatExtensionParameters object itself.
     */
    @Generated
    public PineconeChatExtensionParameters setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    /**
     * Get the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @return the topNDocuments value.
     */
    @Generated
    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    /**
     * Set the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @param topNDocuments the topNDocuments value to set.
     * @return the PineconeChatExtensionParameters object itself.
     */
    @Generated
    public PineconeChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    /**
     * Get the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @return the inScope value.
     */
    @Generated
    public Boolean isInScope() {
        return this.inScope;
    }

    /**
     * Set the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @param inScope the inScope value to set.
     * @return the PineconeChatExtensionParameters object itself.
     */
    @Generated
    public PineconeChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    /**
     * Get the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @return the strictness value.
     */
    @Generated
    public Integer getStrictness() {
        return this.strictness;
    }

    /**
     * Set the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @param strictness the strictness value to set.
     * @return the PineconeChatExtensionParameters object itself.
     */
    @Generated
    public PineconeChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    /**
     * Get the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @return the roleInformation value.
     */
    @Generated
    public String getRoleInformation() {
        return this.roleInformation;
    }

    /**
     * Set the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @param roleInformation the roleInformation value to set.
     * @return the PineconeChatExtensionParameters object itself.
     */
    @Generated
    public PineconeChatExtensionParameters setRoleInformation(String roleInformation) {
        this.roleInformation = roleInformation;
        return this;
    }

    /**
     * Get the environment property: The environment name of Pinecone.
     *
     * @return the environment value.
     */
    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    /**
     * Get the indexName property: The name of the Pinecone database index.
     *
     * @return the indexName value.
     */
    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    /**
     * Get the fieldsMapping property: Customized field mapping behavior to use when interacting with the search index.
     *
     * @return the fieldsMapping value.
     */
    @Generated
    public PineconeFieldMappingOptions getFieldsMapping() {
        return this.fieldsMapping;
    }

    /**
     * Get the embeddingDependency property: The embedding dependency for vector search.
     *
     * @return the embeddingDependency value.
     */
    @Generated
    public OnYourDataVectorizationSource getEmbeddingDependency() {
        return this.embeddingDependency;
    }

    /**
     * Creates an instance of PineconeChatExtensionParameters class.
     *
     * @param environment the environment value to set.
     * @param indexName the indexName value to set.
     * @param fieldsMapping the fieldsMapping value to set.
     * @param embeddingDependency the embeddingDependency value to set.
     */
    @Generated
    @JsonCreator
    public PineconeChatExtensionParameters(@JsonProperty(value = "environment") String environment,
        @JsonProperty(value = "index_name") String indexName,
        @JsonProperty(value = "fields_mapping") PineconeFieldMappingOptions fieldsMapping,
        @JsonProperty(value = "embedding_dependency") OnYourDataVectorizationSource embeddingDependency) {
        this.environment = environment;
        this.indexName = indexName;
        this.fieldsMapping = fieldsMapping;
        this.embeddingDependency = embeddingDependency;
    }
}
