// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A representation of the request options that control the behavior of a text-to-speech operation.
 */
@Fluent
public final class SpeechGenerationOptions {

    /*
     * The text to generate audio for. The maximum length is 4096 characters.
     */
    @Generated
    @JsonProperty(value = "input")
    private String input;

    /*
     * The voice to use for text-to-speech.
     */
    @Generated
    @JsonProperty(value = "voice")
    private SpeechVoice voice;

    /*
     * The audio output format for the spoken text. By default, the MP3 format will be used.
     */
    @Generated
    @JsonProperty(value = "response_format")
    private SpeechGenerationResponseFormat responseFormat;

    /*
     * The speed of speech for generated audio. Values are valid in the range from 0.25 to 4.0, with 1.0 the default
     * and higher values corresponding to faster speech.
     */
    @Generated
    @JsonProperty(value = "speed")
    private Double speed;

    /**
     * Creates an instance of SpeechGenerationOptions class.
     *
     * @param input the input value to set.
     * @param voice the voice value to set.
     */
    @Generated
    @JsonCreator
    public SpeechGenerationOptions(@JsonProperty(value = "input") String input,
        @JsonProperty(value = "voice") SpeechVoice voice) {
        this.input = input;
        this.voice = voice;
    }

    /**
     * Get the input property: The text to generate audio for. The maximum length is 4096 characters.
     *
     * @return the input value.
     */
    @Generated
    public String getInput() {
        return this.input;
    }

    /**
     * Get the voice property: The voice to use for text-to-speech.
     *
     * @return the voice value.
     */
    @Generated
    public SpeechVoice getVoice() {
        return this.voice;
    }

    /**
     * Get the responseFormat property: The audio output format for the spoken text. By default, the MP3 format will be
     * used.
     *
     * @return the responseFormat value.
     */
    @Generated
    public SpeechGenerationResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    /**
     * Set the responseFormat property: The audio output format for the spoken text. By default, the MP3 format will be
     * used.
     *
     * @param responseFormat the responseFormat value to set.
     * @return the SpeechGenerationOptions object itself.
     */
    @Generated
    public SpeechGenerationOptions setResponseFormat(SpeechGenerationResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    /**
     * Get the speed property: The speed of speech for generated audio. Values are valid in the range from 0.25 to 4.0,
     * with 1.0 the default and higher values corresponding to faster speech.
     *
     * @return the speed value.
     */
    @Generated
    public Double getSpeed() {
        return this.speed;
    }

    /**
     * Set the speed property: The speed of speech for generated audio. Values are valid in the range from 0.25 to 4.0,
     * with 1.0 the default and higher values corresponding to faster speech.
     *
     * @param speed the speed value to set.
     * @return the SpeechGenerationOptions object itself.
     */
    @Generated
    public SpeechGenerationOptions setSpeed(Double speed) {
        this.speed = speed;
        return this;
    }

    /*
     * The model to use for this text-to-speech request.
     */
    @Generated
    @JsonProperty(value = "model")
    private String model;

    /**
     * Get the model property: The model to use for this text-to-speech request.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Set the model property: The model to use for this text-to-speech request.
     *
     * @param model the model value to set.
     * @return the SpeechGenerationOptions object itself.
     */
    @Generated
    public SpeechGenerationOptions setModel(String model) {
        this.model = model;
        return this;
    }
}
