/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

public final class NonAzureOpenAIClientImpl {
    private final NonAzureOpenAIClientService service;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    public static final String OPEN_AI_ENDPOINT = "https://api.openai.com/v1";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public NonAzureOpenAIClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.service = (NonAzureOpenAIClientService)RestProxy.create(NonAzureOpenAIClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEmbeddingsWithResponseAsync(String modelId, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        try {
            BinaryData embeddingsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(embeddingsOptions, modelId);
            return FluxUtil.withContext(context -> this.service.getEmbeddings(OPEN_AI_ENDPOINT, "application/json", embeddingsOptionsUpdated, requestOptions, (Context)context));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(String modelId, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        try {
            BinaryData embeddingsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(embeddingsOptions, modelId);
            return this.service.getEmbeddingsSync(OPEN_AI_ENDPOINT, "application/json", embeddingsOptionsUpdated, requestOptions, Context.NONE);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCompletionsWithResponseAsync(String modelId, BinaryData completionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        try {
            BinaryData completionsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(completionsOptions, modelId);
            return FluxUtil.withContext(context -> this.service.getCompletions(OPEN_AI_ENDPOINT, "application/json", completionsOptionsUpdated, requestOptions, (Context)context));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(String modelId, BinaryData completionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData completionsOptionsUpdated = null;
        try {
            completionsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(completionsOptions, modelId);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return this.service.getCompletionsSync(OPEN_AI_ENDPOINT, "application/json", completionsOptionsUpdated, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getChatCompletionsWithResponseAsync(String modelId, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        try {
            BinaryData chatCompletionsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(chatCompletionsOptions, modelId);
            return FluxUtil.withContext(context -> this.service.getChatCompletions(OPEN_AI_ENDPOINT, "application/json", chatCompletionsOptionsUpdated, requestOptions, (Context)context));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(String modelId, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData chatCompletionsOptionsUpdated = null;
        try {
            chatCompletionsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(chatCompletionsOptions, modelId);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return this.service.getChatCompletionsSync(OPEN_AI_ENDPOINT, "application/json", chatCompletionsOptionsUpdated, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getImageGenerationsWithResponseAsync(String modelId, BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        try {
            BinaryData imageGenerationOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(imageGenerationOptions, modelId);
            return FluxUtil.withContext(context -> this.service.getImageGenerations(OPEN_AI_ENDPOINT, "application/json", imageGenerationOptionsUpdated, requestOptions, (Context)context));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getImageGenerationsWithResponse(String modelId, BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData imageGenerationOptionsUpdated = null;
        try {
            imageGenerationOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(imageGenerationOptions, modelId);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return this.service.getImageGenerationsSync(OPEN_AI_ENDPOINT, "application/json", imageGenerationOptionsUpdated, requestOptions, Context.NONE);
    }

    public static BinaryData addModelIdJson(BinaryData inputJson, String modelId) throws JsonProcessingException {
        JsonNode jsonNode = JSON_MAPPER.readTree(inputJson.toString());
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            objectNode.put("model", modelId);
            inputJson = BinaryData.fromBytes((byte[])objectNode.toString().getBytes(StandardCharsets.UTF_8));
        }
        return inputJson;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranscriptionAsResponseObjectWithResponseAsync(String modelId, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAudioTranscriptionAsResponseObject(OPEN_AI_ENDPOINT, "application/json", audioTranscriptionOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranscriptionAsResponseObjectWithResponse(String modelId, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getAudioTranscriptionAsResponseObjectSync(OPEN_AI_ENDPOINT, "application/json", audioTranscriptionOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranscriptionAsPlainTextWithResponseAsync(String modelId, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAudioTranscriptionAsPlainText(OPEN_AI_ENDPOINT, "application/json", audioTranscriptionOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranscriptionAsPlainTextWithResponse(String modelId, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getAudioTranscriptionAsPlainTextSync(OPEN_AI_ENDPOINT, "application/json", audioTranscriptionOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranslationAsResponseObjectWithResponseAsync(String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAudioTranslationAsResponseObject(OPEN_AI_ENDPOINT, "application/json", audioTranslationOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranslationAsResponseObjectWithResponse(String modelId, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getAudioTranslationAsResponseObjectSync(OPEN_AI_ENDPOINT, "application/json", audioTranslationOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranslationAsPlainTextWithResponseAsync(String modelId, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAudioTranslationAsPlainText(OPEN_AI_ENDPOINT, "application/json", audioTranslationOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranslationAsPlainTextWithResponse(String modelId, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getAudioTranslationAsPlainTextSync(OPEN_AI_ENDPOINT, "application/json", audioTranslationOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> generateSpeechFromTextWithResponseAsync(String modelId, BinaryData speechGenerationOptions, RequestOptions requestOptions) {
        String accept = "application/octet-stream, application/json";
        return FluxUtil.withContext(context -> this.service.generateSpeechFromText(OPEN_AI_ENDPOINT, "application/octet-stream, application/json", speechGenerationOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> generateSpeechFromTextWithResponse(BinaryData speechGenerationOptions, RequestOptions requestOptions) {
        String accept = "application/octet-stream, application/json";
        return this.service.generateSpeechFromTextSync(OPEN_AI_ENDPOINT, "application/octet-stream, application/json", speechGenerationOptions, requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="OpenAIClient")
    public static interface NonAzureOpenAIClientService {
        @Post(value="/embeddings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getEmbeddings(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/embeddings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getEmbeddingsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCompletions(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCompletionsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/chat/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getChatCompletions(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/chat/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getChatCompletionsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/images/generations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getImageGenerations(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/images/generations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getImageGenerationsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/transcriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAudioTranscriptionAsResponseObject(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/transcriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getAudioTranscriptionAsResponseObjectSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/transcriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAudioTranscriptionAsPlainText(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/transcriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getAudioTranscriptionAsPlainTextSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/translations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAudioTranslationAsResponseObject(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/translations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getAudioTranslationAsResponseObjectSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/translations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAudioTranslationAsPlainText(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/translations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getAudioTranslationAsPlainTextSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/speech")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> generateSpeechFromText(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/speech")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> generateSpeechFromTextSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);
    }
}

