// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A representation of the available Azure OpenAI enhancement configurations.
 */
@Fluent
public final class AzureChatEnhancementConfiguration {

    /*
     * A representation of the available options for the Azure OpenAI grounding enhancement.
     */
    @Generated
    @JsonProperty(value = "grounding")
    private AzureChatGroundingEnhancementConfiguration grounding;

    /*
     * A representation of the available options for the Azure OpenAI optical character recognition (OCR) enhancement.
     */
    @Generated
    @JsonProperty(value = "ocr")
    private AzureChatOCREnhancementConfiguration ocr;

    /**
     * Creates an instance of AzureChatEnhancementConfiguration class.
     */
    @Generated
    public AzureChatEnhancementConfiguration() {
    }

    /**
     * Get the grounding property: A representation of the available options for the Azure OpenAI grounding
     * enhancement.
     *
     * @return the grounding value.
     */
    @Generated
    public AzureChatGroundingEnhancementConfiguration getGrounding() {
        return this.grounding;
    }

    /**
     * Set the grounding property: A representation of the available options for the Azure OpenAI grounding
     * enhancement.
     *
     * @param grounding the grounding value to set.
     * @return the AzureChatEnhancementConfiguration object itself.
     */
    @Generated
    public AzureChatEnhancementConfiguration setGrounding(AzureChatGroundingEnhancementConfiguration grounding) {
        this.grounding = grounding;
        return this;
    }

    /**
     * Get the ocr property: A representation of the available options for the Azure OpenAI optical character
     * recognition (OCR) enhancement.
     *
     * @return the ocr value.
     */
    @Generated
    public AzureChatOCREnhancementConfiguration getOcr() {
        return this.ocr;
    }

    /**
     * Set the ocr property: A representation of the available options for the Azure OpenAI optical character
     * recognition (OCR) enhancement.
     *
     * @param ocr the ocr value to set.
     * @return the AzureChatEnhancementConfiguration object itself.
     */
    @Generated
    public AzureChatEnhancementConfiguration setOcr(AzureChatOCREnhancementConfiguration ocr) {
        this.ocr = ocr;
        return this;
    }
}
