// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A representation of the additional context information available when Azure OpenAI chat extensions are involved
 * in the generation of a corresponding chat completions response. This context information is only populated when
 * using an Azure OpenAI request configured to use a matching extension.
 */
@Immutable
public final class AzureChatExtensionsMessageContext {

    /**
     * Creates an instance of AzureChatExtensionsMessageContext class.
     */
    @Generated
    private AzureChatExtensionsMessageContext() {
    }

    /*
     * The contextual information associated with the Azure chat extensions used for a chat completions request.
     * These messages describe the data source retrievals, plugin invocations, and other intermediate steps taken in
     * the
     * course of generating a chat completions response that was augmented by capabilities from Azure OpenAI chat
     * extensions.
     */
    @Generated
    @JsonProperty(value = "citations")
    private List<AzureChatExtensionDataSourceResponseCitation> citations;

    /*
     * The detected intent from the chat history, used to pass to the next turn to carry over the context.
     */
    @Generated
    @JsonProperty(value = "intent")
    private String intent;

    /**
     * Get the citations property: The contextual information associated with the Azure chat extensions used for a
     * chat completions request.
     * These messages describe the data source retrievals, plugin invocations, and other intermediate steps taken in
     * the
     * course of generating a chat completions response that was augmented by capabilities from Azure OpenAI chat
     * extensions.
     *
     * @return the citations value.
     */
    @Generated
    public List<AzureChatExtensionDataSourceResponseCitation> getCitations() {
        return this.citations;
    }

    /**
     * Get the intent property: The detected intent from the chat history, used to pass to the next turn to carry over
     * the context.
     *
     * @return the intent value.
     */
    @Generated
    public String getIntent() {
        return this.intent;
    }
}
