// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Log probability information for a choice, as requested via 'logprobs' and 'top_logprobs'.
 */
@Immutable
public final class ChatChoiceLogProbabilityInfo {

    /*
     * The list of log probability information entries for the choice's message content tokens, as requested via the
     * 'logprobs' option.
     */
    @Generated
    @JsonProperty(value = "content")
    private List<ChatTokenLogProbabilityResult> content;

    /**
     * Creates an instance of ChatChoiceLogProbabilityInfo class.
     *
     * @param content the content value to set.
     */
    @Generated
    @JsonCreator
    private ChatChoiceLogProbabilityInfo(@JsonProperty(value = "content") List<ChatTokenLogProbabilityResult> content) {
        this.content = content;
    }

    /**
     * Get the content property: The list of log probability information entries for the choice's message content
     * tokens, as requested via the 'logprobs' option.
     *
     * @return the content value.
     */
    @Generated
    public List<ChatTokenLogProbabilityResult> getContent() {
        return this.content;
    }
}
