// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A tool selection of a specific, named function tool that will limit chat completions to using the named function.
 */
@Immutable
public final class ChatCompletionsFunctionToolSelection {

    /*
     * The name of the function that should be called.
     */
    @Generated
    @JsonProperty(value = "name")
    private String name;

    /**
     * Creates an instance of ChatCompletionsFunctionToolSelection class.
     *
     * @param name the name value to set.
     */
    @Generated
    @JsonCreator
    public ChatCompletionsFunctionToolSelection(@JsonProperty(value = "name") String name) {
        this.name = name;
    }

    /**
     * Get the name property: The name of the function that should be called.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }
}
