// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * An abstract representation of a structured content item within a chat message.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "type",
    defaultImpl = ChatMessageContentItem.class)
@JsonTypeName("ChatMessageContentItem")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "text", value = ChatMessageTextContentItem.class),
    @JsonSubTypes.Type(name = "image_url", value = ChatMessageImageContentItem.class) })
@Immutable
public class ChatMessageContentItem {

    /**
     * Creates an instance of ChatMessageContentItem class.
     */
    @Generated
    public ChatMessageContentItem() {
    }
}
