// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A structured chat content item containing plain text.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("text")
@Immutable
public final class ChatMessageTextContentItem extends ChatMessageContentItem {

    /*
     * The content of the message.
     */
    @Generated
    @JsonProperty(value = "text")
    private String text;

    /**
     * Creates an instance of ChatMessageTextContentItem class.
     *
     * @param text the text value to set.
     */
    @Generated
    @JsonCreator
    public ChatMessageTextContentItem(@JsonProperty(value = "text") String text) {
        this.text = text;
    }

    /**
     * Get the text property: The content of the message.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }
}
