// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import static com.azure.ai.openai.implementation.EmbeddingsUtils.convertBase64ToFloatList;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Representation of a single embeddings relatedness comparison.
 */
@Immutable
public final class EmbeddingItem {

    /*
     * List of embeddings value for the input prompt. These represent a measurement of the
     * vector-based relatedness of the provided input.
     */
    @JsonProperty(value = "embedding")
    private BinaryData embedding;

    private final String embeddingBase64;

    /**
     * Get the embedding property: List of embeddings value for the input prompt. These represent a measurement of the
     * vector-based relatedness of the provided input.
     *
     * @return the embedding value.
     */
    public List<Float> getEmbedding() {
        return convertBase64ToFloatList(embeddingBase64);
    }

    /**
     * Get the embedding property: List of embeddings value in base64 format for the input prompt.
     *
     * @return the embedding base64 encoded string.
     */
    public String getEmbeddingAsString() {
        return embeddingBase64;
    }

    /*
     * Index of the prompt to which the EmbeddingItem corresponds.
     */
    @Generated
    @JsonProperty(value = "index")
    private int promptIndex;

    /**
     * Get the promptIndex property: Index of the prompt to which the EmbeddingItem corresponds.
     *
     * @return the promptIndex value.
     */
    @Generated
    public int getPromptIndex() {
        return this.promptIndex;
    }

    /**
     * Creates an instance of EmbeddingItem class.
     *
     * @param embedding the embedding value to set.
     * @param promptIndex the promptIndex value to set.
     */
    @JsonCreator
    private EmbeddingItem(@JsonProperty(value = "embedding") BinaryData embedding,
        @JsonProperty(value = "index") int promptIndex) {
        this.embedding = embedding;
        this.promptIndex = promptIndex;
        embeddingBase64 = embedding.toString();
    }
}
