// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The definition of a caller-specified function that chat completions may invoke in response to matching user input.
 */
@Fluent
public final class FunctionDefinition {

    /*
     * The name of the function to be called.
     */
    @Generated
    @JsonProperty(value = "name")
    private String name;

    /*
     * A description of what the function does. The model will use this description when selecting the function and
     * interpreting its parameters.
     */
    @Generated
    @JsonProperty(value = "description")
    private String description;

    /*
     * The parameters the function accepts, described as a JSON Schema object.
     */
    @JsonProperty(value = "parameters")
    private BinaryData parameters;

    /**
     * Creates an instance of FunctionDefinition class.
     *
     * @param name the name value to set.
     */
    @Generated
    @JsonCreator
    public FunctionDefinition(@JsonProperty(value = "name") String name) {
        this.name = name;
    }

    /**
     * Get the name property: The name of the function to be called.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the description property: A description of what the function does. The model will use this description when
     * selecting the function and
     * interpreting its parameters.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: A description of what the function does. The model will use this description when
     * selecting the function and
     * interpreting its parameters.
     *
     * @param description the description value to set.
     * @return the FunctionDefinition object itself.
     */
    @Generated
    public FunctionDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the parameters property: The parameters the function accepts, described as a JSON Schema object.
     *
     * @return the parameters value.
     */
    public BinaryData getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameters the function accepts, described as a JSON Schema object.
     *
     * @param parameters the parameters value to set.
     * @return the FunctionDefinition object itself.
     */
    public FunctionDefinition setParameters(BinaryData parameters) {
        this.parameters = parameters;
        return this;
    }
}
