// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A representation of a single generated image, provided as either base64-encoded data or as a URL from which the
 * image
 * may be retrieved.
 */
@Immutable
public final class ImageGenerationData {

    /*
     * The URL that provides temporary access to download the generated image.
     */
    @Generated
    @JsonProperty(value = "url")
    private String url;

    /*
     * The complete data for an image, represented as a base64-encoded string.
     */
    @Generated
    @JsonProperty(value = "b64_json")
    private String base64Data;

    /*
     * The final prompt used by the model to generate the image.
     * Only provided with dall-3-models and only when revisions were made to the prompt.
     */
    @Generated
    @JsonProperty(value = "revised_prompt")
    private String revisedPrompt;

    /**
     * Creates an instance of ImageGenerationData class.
     */
    @Generated
    private ImageGenerationData() {
    }

    /**
     * Get the url property: The URL that provides temporary access to download the generated image.
     *
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * Get the base64Data property: The complete data for an image, represented as a base64-encoded string.
     *
     * @return the base64Data value.
     */
    @Generated
    public String getBase64Data() {
        return this.base64Data;
    }

    /**
     * Get the revisedPrompt property: The final prompt used by the model to generate the image.
     * Only provided with dall-3-models and only when revisions were made to the prompt.
     *
     * @return the revisedPrompt value.
     */
    @Generated
    public String getRevisedPrompt() {
        return this.revisedPrompt;
    }

    /*
     * Information about the content filtering results.
     */
    @Generated
    @JsonProperty(value = "content_filter_results")
    private ImageGenerationContentFilterResults contentFilterResults;

    /*
     * Information about the content filtering category (hate, sexual, violence, self_harm), if
     * it has been detected, as well as the severity level (very_low, low, medium, high-scale
     * that determines the intensity and risk level of harmful content) and if it has been
     * filtered or not. Information about jailbreak content and profanity, if it has been detected,
     * and if it has been filtered or not. And information about customer block list, if it has
     * been filtered and its id.
     */
    @Generated
    @JsonProperty(value = "prompt_filter_results")
    private ImageGenerationPromptFilterResults promptFilterResults;

    /**
     * Get the contentFilterResults property: Information about the content filtering results.
     *
     * @return the contentFilterResults value.
     */
    @Generated
    public ImageGenerationContentFilterResults getContentFilterResults() {
        return this.contentFilterResults;
    }

    /**
     * Get the promptFilterResults property: Information about the content filtering category (hate, sexual, violence,
     * self_harm), if
     * it has been detected, as well as the severity level (very_low, low, medium, high-scale
     * that determines the intensity and risk level of harmful content) and if it has been
     * filtered or not. Information about jailbreak content and profanity, if it has been detected,
     * and if it has been filtered or not. And information about customer block list, if it has
     * been filtered and its id.
     *
     * @return the promptFilterResults value.
     */
    @Generated
    public ImageGenerationPromptFilterResults getPromptFilterResults() {
        return this.promptFilterResults;
    }
}
